/*
 * Decompiled with CFR 0.152.
 */
package currency.client.screens;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import currency.procedures.GetCostOfItemsProcedure;
import currency.procedures.GetItemForSaleProcedure;
import currency.procedures.ShopInfoDisplayOverlayIngameProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ShopInfoOverlay {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void eventHandler(RenderGuiEvent.Pre event) {
        int w = event.getGuiGraphics().guiWidth();
        int h = event.getGuiGraphics().guiHeight();
        Level world = null;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        LocalPlayer entity = Minecraft.getInstance().player;
        if (entity != null) {
            world = entity.level();
            x = entity.getX();
            y = entity.getY();
            z = entity.getZ();
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (ShopInfoDisplayOverlayIngameProcedure.execute((LevelAccessor)world, (Entity)entity)) {
            event.getGuiGraphics().blit(ResourceLocation.parse((String)"currency:textures/screens/shop_info_show.png"), w / 2 + -63, h / 2 + -44, 0.0f, 0.0f, 125, 75, 125, 75);
            event.getGuiGraphics().drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.currency.shop_info.label_items_for_sale"), w / 2 + -61, h / 2 + -38, -1, false);
            event.getGuiGraphics().drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.currency.shop_info.label_cost"), w / 2 + -61, h / 2 + -4, -1, false);
            event.getGuiGraphics().drawString(Minecraft.getInstance().font, GetItemForSaleProcedure.execute((LevelAccessor)world, (Entity)entity), w / 2 + -60, h / 2 + -23, -1, false);
            event.getGuiGraphics().drawString(Minecraft.getInstance().font, GetCostOfItemsProcedure.execute((LevelAccessor)world, (Entity)entity), w / 2 + -60, h / 2 + 11, -1, false);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

