/*
 * Decompiled with CFR 0.152.
 */
package currency.network;

import currency.CurrencyMod;
import currency.procedures.AddFiftyDollarATMProcedure;
import currency.procedures.AddFiveDollarATMProcedure;
import currency.procedures.AddHundredDollarATMProcedure;
import currency.procedures.AddOneDollarATMProcedure;
import currency.procedures.AddTenDollarATMProcedure;
import currency.procedures.AddTwentyDollarATMProcedure;
import currency.world.inventory.ATMDepositMenu;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ATMDepositButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ATMDepositButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"currency", (String)"atm_deposit_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ATMDepositButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new ATMDepositButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<ATMDepositButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(ATMDepositButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                ATMDepositButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = ATMDepositMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            AddOneDollarATMProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            AddFiveDollarATMProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            AddTenDollarATMProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            AddTwentyDollarATMProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            AddFiftyDollarATMProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            AddHundredDollarATMProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CurrencyMod.addNetworkMessage(TYPE, STREAM_CODEC, ATMDepositButtonMessage::handleData);
    }
}

