/*
 * Decompiled with CFR 0.152.
 */
package currency.network;

import currency.CurrencyMod;
import currency.procedures.BuyFiveScratchProcedure;
import currency.procedures.BuyOneScratchProcedure;
import currency.procedures.BuyTenScratchProcedure;
import currency.procedures.BuyTwentyScratchProcedure;
import currency.world.inventory.BuyScratchMenu;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record BuyScratchButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BuyScratchButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"currency", (String)"buy_scratch_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BuyScratchButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new BuyScratchButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<BuyScratchButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(BuyScratchButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                BuyScratchButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = BuyScratchMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BuyOneScratchProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            BuyFiveScratchProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            BuyTenScratchProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            BuyTwentyScratchProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CurrencyMod.addNetworkMessage(TYPE, STREAM_CODEC, BuyScratchButtonMessage::handleData);
    }
}

