/*
 * Decompiled with CFR 0.152.
 */
package currency.network;

import currency.CurrencyMod;
import currency.procedures.AddFiftyDollarATMProcedure;
import currency.procedures.AddFiveDollarATMProcedure;
import currency.procedures.AddHundredDollarATMProcedure;
import currency.procedures.AddOneDollarATMProcedure;
import currency.procedures.AddTenDollarATMProcedure;
import currency.procedures.AddTwentyDollarATMProcedure;
import currency.world.inventory.ATMDepositMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ATMDepositButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ATMDepositButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ATMDepositButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ATMDepositButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ATMDepositButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ATMDepositButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ATMDepositMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            AddOneDollarATMProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            AddFiveDollarATMProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            AddTenDollarATMProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            AddTwentyDollarATMProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            AddFiftyDollarATMProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            AddHundredDollarATMProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CurrencyMod.addNetworkMessage(ATMDepositButtonMessage.class, ATMDepositButtonMessage::buffer, ATMDepositButtonMessage::new, ATMDepositButtonMessage::handler);
    }
}

