/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.bungee.listener;

import com.github.gerolndnr.connectionguard.bungee.ConnectionGuardBungeePlugin;
import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.geo.GeoResult;
import com.github.gerolndnr.connectionguard.core.luckperms.CGLuckPermsHelper;
import com.github.gerolndnr.connectionguard.core.vpn.VpnResult;
import com.github.gerolndnr.connectionguard.core.webhook.CGWebHookHelper;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class ConnectionGuardBungeeListener
implements Listener {
    @EventHandler
    public void onLogin(LoginEvent loginEvent) {
        CompletableFuture<Boolean> hasGeoExemptionPermissionFuture;
        CompletableFuture<Optional<Object>> geoResultOptionalFuture;
        CompletableFuture<Boolean> hasVpnExemptionPermissionFuture;
        CompletableFuture<VpnResult> vpnResultFuture;
        loginEvent.registerIntent((Plugin)ConnectionGuardBungeePlugin.getInstance());
        String ipAddress = loginEvent.getConnection().getAddress().getAddress().getHostAddress();
        if (ConnectionGuardBungeePlugin.getInstance().getConfig().getStringList("behavior.vpn.exemptions").contains(ipAddress) || ConnectionGuardBungeePlugin.getInstance().getConfig().getStringList("behavior.vpn.exemptions").contains(loginEvent.getConnection().getUniqueId().toString()) || ConnectionGuardBungeePlugin.getInstance().getConfig().getStringList("behavior.vpn.exemptions").contains(loginEvent.getConnection().getName())) {
            vpnResultFuture = CompletableFuture.completedFuture(new VpnResult(ipAddress, false));
            hasVpnExemptionPermissionFuture = CompletableFuture.completedFuture(false);
        } else {
            vpnResultFuture = ConnectionGuard.getVpnResult(ipAddress);
            hasVpnExemptionPermissionFuture = ConnectionGuardBungeePlugin.getInstance().getConfig().getBoolean("behavior.vpn.use-permission-exemption") ? CGLuckPermsHelper.hasPermission(loginEvent.getConnection().getUniqueId(), "connectionguard.exemption.vpn") : CompletableFuture.completedFuture(false);
        }
        if (ConnectionGuardBungeePlugin.getInstance().getConfig().getStringList("behavior.geo.exemptions").contains(ipAddress) || ConnectionGuardBungeePlugin.getInstance().getConfig().getStringList("behavior.geo.exemptions").contains(loginEvent.getConnection().getUniqueId().toString()) || ConnectionGuardBungeePlugin.getInstance().getConfig().getStringList("behavior.geo.exemptions").contains(loginEvent.getConnection().getName())) {
            geoResultOptionalFuture = CompletableFuture.completedFuture(Optional.empty());
            hasGeoExemptionPermissionFuture = CompletableFuture.completedFuture(false);
        } else {
            geoResultOptionalFuture = ConnectionGuard.getGeoResult(ipAddress);
            hasGeoExemptionPermissionFuture = ConnectionGuardBungeePlugin.getInstance().getConfig().getBoolean("behavior.geo.use-permission-exemption") ? CGLuckPermsHelper.hasPermission(loginEvent.getConnection().getUniqueId(), "connectionguard.exemption.geo") : CompletableFuture.completedFuture(false);
        }
        CompletableFuture.allOf(vpnResultFuture, geoResultOptionalFuture, hasVpnExemptionPermissionFuture, hasGeoExemptionPermissionFuture).thenRun(() -> {
            Optional geoResultOptional;
            VpnResult vpnResult = (VpnResult)vpnResultFuture.join();
            Boolean hasVpnExemption = (Boolean)hasVpnExemptionPermissionFuture.join();
            Boolean hasGeoExemption = (Boolean)hasGeoExemptionPermissionFuture.join();
            if (vpnResult.isVpn() && !hasVpnExemption.booleanValue()) {
                if (ConnectionGuardBungeePlugin.getInstance().getConfig().getBoolean("behavior.vpn.notify-staff")) {
                    String notifyMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardBungeePlugin.getInstance().getLanguageConfig().getString("messages.vpn-notify").replaceAll("%IP%", vpnResult.getIpAddress()).replaceAll("%NAME%", loginEvent.getConnection().getName()));
                    this.broadcastMessage(notifyMessage, "connectionguard.notify.vpn");
                }
                if (ConnectionGuardBungeePlugin.getInstance().getConfig().getBoolean("behavior.vpn.execute-command.enabled")) {
                    ConnectionGuardBungeePlugin.getInstance().getProxy().getPluginManager().dispatchCommand(ConnectionGuardBungeePlugin.getInstance().getProxy().getConsole(), ConnectionGuardBungeePlugin.getInstance().getConfig().getString("behavior.vpn.execute-command.command").replaceAll("%NAME%", loginEvent.getConnection().getName()).replaceAll("%IP%", ipAddress));
                }
                if (ConnectionGuardBungeePlugin.getInstance().getConfig().getBoolean("behavior.vpn.send-webhook.enabled")) {
                    String webhookMessage = ConnectionGuardBungeePlugin.getInstance().getLanguageConfig().getString("messages.vpn-webhook").replaceAll("%NAME%", loginEvent.getConnection().getName()).replaceAll("%IP%", ipAddress);
                    String webhookUrl = ConnectionGuardBungeePlugin.getInstance().getConfig().getString("behavior.vpn.send-webhook.url");
                    CGWebHookHelper.sendWebHook(webhookUrl, webhookMessage);
                }
                if (ConnectionGuardBungeePlugin.getInstance().getConfig().getBoolean("behavior.vpn.kick-player")) {
                    String kickMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardBungeePlugin.getInstance().getLanguageConfig().getString("messages.vpn-block").replaceAll("%IP%", vpnResult.getIpAddress()).replaceAll("%NAME%", loginEvent.getConnection().getName()));
                    loginEvent.setCancelReason(new BaseComponent[]{new TextComponent(kickMessage)});
                    loginEvent.setCancelled(true);
                    loginEvent.completeIntent((Plugin)ConnectionGuardBungeePlugin.getInstance());
                    return;
                }
            }
            if ((geoResultOptional = (Optional)geoResultOptionalFuture.join()).isPresent() && !hasGeoExemption.booleanValue()) {
                GeoResult geoResult = (GeoResult)geoResultOptional.get();
                boolean isGeoFlagged = false;
                switch (ConnectionGuardBungeePlugin.getInstance().getConfig().getString("behavior.geo.type").toLowerCase()) {
                    case "blacklist": {
                        if (!ConnectionGuardBungeePlugin.getInstance().getConfig().getStringList("behavior.geo.list").contains(geoResult.getCountryName())) break;
                        isGeoFlagged = true;
                        break;
                    }
                    case "whitelist": {
                        if (ConnectionGuardBungeePlugin.getInstance().getConfig().getStringList("behavior.geo.list").contains(geoResult.getCountryName())) break;
                        isGeoFlagged = true;
                        break;
                    }
                    default: {
                        ConnectionGuard.getLogger().info("Invalid geo behavior type. Please use BLACKLIST or WHITELIST.");
                    }
                }
                if (isGeoFlagged) {
                    if (ConnectionGuardBungeePlugin.getInstance().getConfig().getBoolean("behavior.geo.notify-staff")) {
                        String notifyMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardBungeePlugin.getInstance().getLanguageConfig().getString("messages.geo-notify").replaceAll("%IP%", geoResult.getIpAddress()).replaceAll("%COUNTRY%", geoResult.getCountryName()).replaceAll("%CITY%", geoResult.getCityName()).replaceAll("%ISP%", geoResult.getIspName()).replaceAll("%NAME%", loginEvent.getConnection().getName()));
                        this.broadcastMessage(notifyMessage, "connectionguard.notify.geo");
                    }
                    if (ConnectionGuardBungeePlugin.getInstance().getConfig().getBoolean("behavior.geo.execute-command.enabled")) {
                        ConnectionGuardBungeePlugin.getInstance().getProxy().getPluginManager().dispatchCommand(ConnectionGuardBungeePlugin.getInstance().getProxy().getConsole(), ConnectionGuardBungeePlugin.getInstance().getConfig().getString("behavior.geo.execute-command.command").replaceAll("%NAME%", loginEvent.getConnection().getName()).replaceAll("%IP%", ipAddress));
                    }
                    if (ConnectionGuardBungeePlugin.getInstance().getConfig().getBoolean("behavior.geo.send-webhook.enabled")) {
                        String webhookMessage = ConnectionGuardBungeePlugin.getInstance().getLanguageConfig().getString("messages.geo-webhook").replaceAll("%NAME%", loginEvent.getConnection().getName()).replaceAll("%IP%", ipAddress).replaceAll("%COUNTRY%", geoResult.getCountryName()).replaceAll("%CITY%", geoResult.getCityName()).replaceAll("%ISP%", geoResult.getIspName());
                        String webhookUrl = ConnectionGuardBungeePlugin.getInstance().getConfig().getString("behavior.geo.send-webhook.url");
                        CGWebHookHelper.sendWebHook(webhookUrl, webhookMessage);
                    }
                    if (ConnectionGuardBungeePlugin.getInstance().getConfig().getBoolean("behavior.geo.kick-player")) {
                        String kickMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardBungeePlugin.getInstance().getLanguageConfig().getString("messages.geo-block").replaceAll("%IP%", geoResult.getIpAddress()).replaceAll("%COUNTRY%", geoResult.getCountryName()).replaceAll("%CITY%", geoResult.getCityName()).replaceAll("%ISP%", geoResult.getIspName()).replaceAll("%NAME%", loginEvent.getConnection().getName()));
                        loginEvent.setCancelReason(new BaseComponent[]{new TextComponent(kickMessage)});
                        loginEvent.setCancelled(true);
                        loginEvent.completeIntent((Plugin)ConnectionGuardBungeePlugin.getInstance());
                        return;
                    }
                }
            }
            loginEvent.completeIntent((Plugin)ConnectionGuardBungeePlugin.getInstance());
        });
    }

    private void broadcastMessage(String message, String permission) {
        for (ProxiedPlayer proxiedPlayer : ConnectionGuardBungeePlugin.getInstance().getProxy().getPlayers()) {
            if (!proxiedPlayer.hasPermission(permission)) continue;
            proxiedPlayer.sendMessage(TextComponent.fromLegacyText((String)message));
        }
    }
}

