/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.core.vpn.custom;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.vpn.VpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.VpnResult;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.JsonElement;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.JsonObject;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.JsonParser;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class CustomVpnProvider
implements VpnProvider {
    private String requestType;
    private String requestUrl;
    private List<String> requestHeaders;
    private String requestBodyType;
    private String requestBody;
    private String responseType;
    private String isVpnFieldName;
    private String isVpnFieldType;
    private String isVpnString;
    private String vpnProviderFieldName;

    public CustomVpnProvider(String requestType, String requestUrl, List<String> requestHeaders, String requestBodyType, String requestBody, String responseType, String isVpnFieldName, String isVpnFieldType, String isVpnString, String vpnProviderFieldName) {
        this.requestType = requestType;
        this.requestUrl = requestUrl;
        this.requestHeaders = requestHeaders;
        this.requestBodyType = requestBodyType;
        this.requestBody = requestBody;
        this.responseType = responseType;
        this.isVpnFieldName = isVpnFieldName;
        this.isVpnFieldType = isVpnFieldType;
        this.isVpnString = isVpnString;
        this.vpnProviderFieldName = vpnProviderFieldName;
    }

    @Override
    public CompletableFuture<Optional<VpnResult>> getVpnResult(String ipAddress) {
        return CompletableFuture.supplyAsync(() -> {
            Response response;
            OkHttpClient httpClient = new OkHttpClient();
            Request.Builder requestBuilder = new Request.Builder().url(this.requestUrl.replaceAll("%IP%", ipAddress));
            switch (this.requestType.toUpperCase()) {
                case "GET": {
                    break;
                }
                case "POST": {
                    requestBuilder = requestBuilder.post(RequestBody.create((String)this.requestBody.replaceAll("%IP%", ipAddress), (MediaType)MediaType.get((String)this.requestBodyType)));
                    break;
                }
                default: {
                    ConnectionGuard.getLogger().info("Custom Detection Provider | Unknown request type. Please use 'GET' or 'POST'!");
                    return Optional.empty();
                }
            }
            for (String header : this.requestHeaders) {
                String[] headerSplit = header.split(":");
                if (headerSplit.length != 2) continue;
                requestBuilder = requestBuilder.addHeader(headerSplit[0], headerSplit[1]);
            }
            try {
                response = httpClient.newCall(requestBuilder.build()).execute();
            }
            catch (IOException e) {
                ConnectionGuard.getLogger().info("Could not execute GET request on custom vpn detection provider.");
                return Optional.empty();
            }
            switch (this.responseType.toLowerCase()) {
                case "application/json": {
                    try {
                        return this.readJsonResponse(ipAddress, response.body().string());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            ConnectionGuard.getLogger().info("Custom Detection Provider | Unknown response type. Please use 'application/json'!");
            return Optional.empty();
        });
    }

    private Optional<VpnResult> readJsonResponse(String ipAddress, String responseBody) {
        JsonElement jsonElement = JsonParser.parseString((String)responseBody);
        String[] isVpnTree = this.isVpnFieldName.replaceAll("%IP%", ipAddress).split("#");
        if (isVpnTree.length == 0) {
            isVpnTree = new String[]{this.isVpnFieldName.replaceAll("%IP%", ipAddress)};
        }
        JsonObject isVpnObject = jsonElement.getAsJsonObject();
        boolean isVpn = false;
        for (int i = 0; i < isVpnTree.length; ++i) {
            if (isVpnTree.length - 1 == i) {
                String isVpnResult;
                if (this.isVpnFieldType.equalsIgnoreCase("STRING") && (isVpnResult = isVpnObject.get(isVpnTree[i]).getAsString()).equalsIgnoreCase(this.isVpnString)) {
                    isVpn = true;
                    break;
                }
                if (!this.isVpnFieldType.equalsIgnoreCase("BOOLEAN")) continue;
                isVpn = isVpnObject.get(isVpnTree[i]).getAsBoolean();
                break;
            }
            isVpnObject = isVpnObject.getAsJsonObject(isVpnTree[i]);
        }
        if (this.vpnProviderFieldName.equalsIgnoreCase("")) {
            return Optional.of(new VpnResult(ipAddress, isVpn));
        }
        String[] vpnProviderNameTree = this.vpnProviderFieldName.replaceAll("%IP%", ipAddress).split(".");
        if (vpnProviderNameTree.length == 0) {
            vpnProviderNameTree = new String[]{this.vpnProviderFieldName.replaceAll("%IP%", ipAddress)};
        }
        JsonObject vpnProviderNameObject = jsonElement.getAsJsonObject();
        String vpnProviderName = "";
        for (int i = 0; i < vpnProviderNameTree.length; ++i) {
            if (vpnProviderNameTree.length - 1 == i) {
                vpnProviderName = vpnProviderNameObject.get(vpnProviderNameTree[i]).getAsString();
                break;
            }
            vpnProviderNameObject = vpnProviderNameObject.get(vpnProviderNameTree[i]).getAsJsonObject();
        }
        return Optional.of(new VpnResult(ipAddress, isVpn, Optional.of(vpnProviderName)));
    }
}

