/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.spigot;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.cache.NoCacheProvider;
import com.github.gerolndnr.connectionguard.core.cache.RedisCacheProvider;
import com.github.gerolndnr.connectionguard.core.cache.SQLiteCacheProvider;
import com.github.gerolndnr.connectionguard.core.geo.IpApiGeoProvider;
import com.github.gerolndnr.connectionguard.core.geo.ProxyCheckGeoProvider;
import com.github.gerolndnr.connectionguard.core.vpn.IpApiVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.IpHubVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.ProxyCheckVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.VpnApiVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.VpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.custom.CustomVpnProvider;
import com.github.gerolndnr.connectionguard.libs.com.alessiodp.libby.BukkitLibraryManager;
import com.github.gerolndnr.connectionguard.libs.com.alessiodp.libby.Library;
import com.github.gerolndnr.connectionguard.libs.org.bstats.bukkit.Metrics;
import com.github.gerolndnr.connectionguard.spigot.commands.ConnectionGuardSpigotCommand;
import com.github.gerolndnr.connectionguard.spigot.listener.AsyncPlayerPreLoginListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ConnectionGuardSpigotPlugin
extends JavaPlugin {
    private static ConnectionGuardSpigotPlugin connectionGuardSpigotPlugin;
    private File languageFile;
    private YamlConfiguration languageConfig;
    private HashMap<String, VpnProvider> vpnProviderMap;

    public void onLoad() {
        connectionGuardSpigotPlugin = this;
        this.vpnProviderMap = new HashMap();
    }

    public void onEnable() {
        this.saveDefaultConfig();
        String selectedLanguageFileName = this.getConfig().getString("message-language") + ".yml";
        if (!new File(this.getDataFolder(), "translation").exists()) {
            this.saveResource("translation" + File.separator + "en.yml", false);
        }
        this.languageFile = new File(this.getDataFolder().toPath().resolve("translation").toFile(), selectedLanguageFileName);
        this.languageConfig = YamlConfiguration.loadConfiguration((File)this.languageFile);
        ConnectionGuard.setLogger(this.getLogger());
        BukkitLibraryManager libraryManager = new BukkitLibraryManager((Plugin)this);
        Library httpLibrary = Library.builder().groupId("com.squareup.okhttp3").artifactId("okhttp").version("4.12.0").resolveTransitiveDependencies(true).build();
        Library gsonLibrary = Library.builder().groupId("com.google.code.gson").artifactId("gson").version("2.11.0").resolveTransitiveDependencies(true).relocate("com{}google{}gson", "com{}github{}gerolndnr{}connectionguard{}libs{}com{}google{}gson").build();
        Library bstatsLibrary = Library.builder().groupId("org#bstats".replaceAll("#", ".")).artifactId("bstats-bukkit").version("3.0.2").resolveTransitiveDependencies(true).relocate("org{}bstats", "com{}github{}gerolndnr{}connectionguard{}libs{}org{}bstats").build();
        libraryManager.addMavenCentral();
        libraryManager.loadLibrary(httpLibrary);
        libraryManager.loadLibrary(gsonLibrary);
        libraryManager.loadLibrary(bstatsLibrary);
        switch (this.getConfig().getString("provider.cache.type").toLowerCase()) {
            case "sqlite": {
                Library sqliteLibrary = Library.builder().groupId("org.xerial").artifactId("sqlite-jdbc").version("3.46.0.0").resolveTransitiveDependencies(true).build();
                libraryManager.loadLibrary(sqliteLibrary);
                ConnectionGuard.setCacheProvider(new SQLiteCacheProvider(new File(this.getDataFolder(), "cache.db").getAbsolutePath()));
                break;
            }
            case "redis": {
                Library jedisLibrary = Library.builder().groupId("redis.clients").artifactId("jedis").version("5.0.0").resolveTransitiveDependencies(true).build();
                libraryManager.loadLibrary(jedisLibrary);
                ConnectionGuard.setCacheProvider(new RedisCacheProvider(this.getConfig().getString("provider.cache.redis.hostname"), this.getConfig().getInt("provider.cache.redis.port"), this.getConfig().getString("provider.cache.redis.username"), this.getConfig().getString("provider.cache.redis.password")));
                break;
            }
            case "disabled": {
                ConnectionGuard.setCacheProvider(new NoCacheProvider());
                break;
            }
            default: {
                this.getLogger().info("The specified cache provider is invalid. Please use SQLite,Redis or disable the cache.");
                this.setEnabled(false);
                return;
            }
        }
        ConnectionGuard.getCacheProvider().setup();
        this.vpnProviderMap.put("proxycheck", new ProxyCheckVpnProvider(this.getConfig().getString("provider.vpn.proxycheck.api-key")));
        this.vpnProviderMap.put("ip-api", new IpApiVpnProvider());
        this.vpnProviderMap.put("iphub", new IpHubVpnProvider(this.getConfig().getString("provider.vpn.iphub.api-key")));
        this.vpnProviderMap.put("vpnapi", new VpnApiVpnProvider(this.getConfig().getString("provider.vpn.vpnapi.api-key")));
        ArrayList<VpnProvider> vpnProviders = new ArrayList<VpnProvider>();
        for (String key : this.getConfig().getConfigurationSection("provider.vpn").getKeys(false)) {
            if (!this.getConfig().getBoolean("provider.vpn." + key + ".enabled")) continue;
            if (this.vpnProviderMap.get(key) != null) {
                vpnProviders.add(this.vpnProviderMap.get(key));
            } else {
                vpnProviders.add(new CustomVpnProvider(this.getConfig().getString("provider.vpn." + key + ".request-type"), this.getConfig().getString("provider.vpn." + key + ".request-url"), this.getConfig().getStringList("provider.vpn." + key + ".request-header"), this.getConfig().getString("provider.vpn." + key + ".request-body-type"), this.getConfig().getString("provider.vpn." + key + ".request-body"), this.getConfig().getString("provider.vpn." + key + ".response-type"), this.getConfig().getString("provider.vpn." + key + ".response-format.is-vpn-field.field-name"), this.getConfig().getString("provider.vpn." + key + ".response-format.is-vpn-field.field-type"), this.getConfig().getString("provider.vpn." + key + ".response-format.is-vpn-field.string-options.is-vpn-string"), this.getConfig().getString("provider.vpn." + key + ".response-format.vpn-provider-field.field-name")));
            }
            ConnectionGuard.getLogger().info("Registered vpn detection provider '" + key + "'.");
        }
        ConnectionGuard.setVpnProviders(vpnProviders);
        switch (this.getConfig().getString("provider.geo.service").toLowerCase()) {
            case "ip-api": {
                ConnectionGuard.setGeoProvider(new IpApiGeoProvider());
                break;
            }
            case "proxycheck": {
                ConnectionGuard.setGeoProvider(new ProxyCheckGeoProvider(this.getConfig().getString("provider.vpn.proxycheck.api-key")));
                break;
            }
            default: {
                this.getLogger().info("The specified geo provider is invalid. Please use IP-API.");
            }
        }
        ConnectionGuard.setRequiredPositiveFlags(this.getConfig().getInt("required-positive-flags"));
        ConnectionGuard.setVpnCacheExpirationTime(this.getConfig().getInt("provider.cache.expiration.vpn"));
        ConnectionGuard.setGeoCacheExpirationTime(this.getConfig().getInt("provider.cache.expiration.geo"));
        this.getServer().getPluginManager().registerEvents((Listener)new AsyncPlayerPreLoginListener(), (Plugin)this);
        this.getCommand("connectionguard").setExecutor((CommandExecutor)new ConnectionGuardSpigotCommand());
        this.getCommand("connectionguard").setTabCompleter((TabCompleter)new ConnectionGuardSpigotCommand());
        Metrics metrics = new Metrics((JavaPlugin)this, 22911);
    }

    public void onDisable() {
        ConnectionGuard.getCacheProvider().disband();
    }

    public YamlConfiguration getLanguageConfig() {
        return this.languageConfig;
    }

    public void reloadAllConfigs() {
        this.reloadConfig();
        this.languageConfig = YamlConfiguration.loadConfiguration((File)this.languageFile);
    }

    public static ConnectionGuardSpigotPlugin getInstance() {
        return connectionGuardSpigotPlugin;
    }
}

