/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.spigot.listener;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.geo.GeoResult;
import com.github.gerolndnr.connectionguard.core.luckperms.CGLuckPermsHelper;
import com.github.gerolndnr.connectionguard.core.vpn.VpnResult;
import com.github.gerolndnr.connectionguard.core.webhook.CGWebHookHelper;
import com.github.gerolndnr.connectionguard.spigot.ConnectionGuardSpigotPlugin;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;

public class AsyncPlayerPreLoginListener
implements Listener {
    @EventHandler
    public void onAsyncPreLogin(final AsyncPlayerPreLoginEvent preLoginEvent) {
        Optional<Object> geoResultOptional;
        CompletableFuture<Boolean> hasGeoExemptionPermissionFuture;
        CompletableFuture<Optional<Object>> geoResultOptionalFuture;
        CompletableFuture<Boolean> hasVpnExemptionPermissionFuture;
        CompletableFuture<VpnResult> vpnResultFuture;
        final String ipAddress = preLoginEvent.getAddress().getHostAddress();
        if (ConnectionGuardSpigotPlugin.getInstance().getConfig().getStringList("behavior.vpn.exemptions").contains(ipAddress) || ConnectionGuardSpigotPlugin.getInstance().getConfig().getStringList("behavior.vpn.exemptions").contains(preLoginEvent.getUniqueId().toString()) || ConnectionGuardSpigotPlugin.getInstance().getConfig().getStringList("behavior.vpn.exemptions").contains(preLoginEvent.getName())) {
            vpnResultFuture = CompletableFuture.completedFuture(new VpnResult(ipAddress, false));
            hasVpnExemptionPermissionFuture = CompletableFuture.completedFuture(false);
        } else {
            vpnResultFuture = ConnectionGuard.getVpnResult(ipAddress);
            hasVpnExemptionPermissionFuture = ConnectionGuardSpigotPlugin.getInstance().getConfig().getBoolean("behavior.vpn.use-permission-exemption") ? CGLuckPermsHelper.hasPermission(preLoginEvent.getUniqueId(), "connectionguard.exemption.vpn") : CompletableFuture.completedFuture(false);
        }
        if (ConnectionGuardSpigotPlugin.getInstance().getConfig().getStringList("behavior.geo.exemptions").contains(ipAddress) || ConnectionGuardSpigotPlugin.getInstance().getConfig().getStringList("behavior.geo.exemptions").contains(preLoginEvent.getUniqueId().toString()) || ConnectionGuardSpigotPlugin.getInstance().getConfig().getStringList("behavior.geo.exemptions").contains(preLoginEvent.getName())) {
            geoResultOptionalFuture = CompletableFuture.completedFuture(Optional.empty());
            hasGeoExemptionPermissionFuture = CompletableFuture.completedFuture(false);
        } else {
            geoResultOptionalFuture = ConnectionGuard.getGeoResult(ipAddress);
            hasGeoExemptionPermissionFuture = ConnectionGuardSpigotPlugin.getInstance().getConfig().getBoolean("behavior.geo.use-permission-exemption") ? CGLuckPermsHelper.hasPermission(preLoginEvent.getUniqueId(), "connectionguard.exemption.geo") : CompletableFuture.completedFuture(false);
        }
        CompletableFuture.allOf(vpnResultFuture, geoResultOptionalFuture, hasVpnExemptionPermissionFuture, hasGeoExemptionPermissionFuture).join();
        VpnResult vpnResult = vpnResultFuture.join();
        Boolean hasVpnExemptionPermission = hasVpnExemptionPermissionFuture.join();
        Boolean hasGeoExemptionPermission = hasGeoExemptionPermissionFuture.join();
        if (vpnResult.isVpn() && !hasVpnExemptionPermission.booleanValue()) {
            if (ConnectionGuardSpigotPlugin.getInstance().getConfig().getBoolean("behavior.vpn.notify-staff")) {
                ConnectionGuard.getLogger().info("staff should be notified");
                String notifyMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("messages.vpn-notify").replaceAll("%IP%", vpnResult.getIpAddress()).replaceAll("%NAME%", preLoginEvent.getName()));
                int amountRecipients = ConnectionGuardSpigotPlugin.getInstance().getServer().broadcast(notifyMessage, "connectionguard.notify.vpn");
                ConnectionGuard.getLogger().info("amount recipients: " + amountRecipients);
            } else {
                ConnectionGuard.getLogger().info("staff should not be notified");
            }
            if (ConnectionGuardSpigotPlugin.getInstance().getConfig().getBoolean("behavior.vpn.execute-command.enabled")) {
                Bukkit.getScheduler().runTask((Plugin)ConnectionGuardSpigotPlugin.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)ConnectionGuardSpigotPlugin.getInstance().getConfig().getString("behavior.vpn.execute-command.command").replaceAll("%NAME%", preLoginEvent.getName()).replaceAll("%IP%", ipAddress));
                    }
                });
            }
            if (ConnectionGuardSpigotPlugin.getInstance().getConfig().getBoolean("behavior.vpn.send-webhook.enabled")) {
                String webhookMessage = ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("messages.vpn-webhook").replaceAll("%NAME%", preLoginEvent.getName()).replaceAll("%IP%", ipAddress);
                String webhookUrl = ConnectionGuardSpigotPlugin.getInstance().getConfig().getString("behavior.vpn.send-webhook.url");
                CGWebHookHelper.sendWebHook(webhookUrl, webhookMessage);
            }
            if (ConnectionGuardSpigotPlugin.getInstance().getConfig().getBoolean("behavior.vpn.kick-player")) {
                String kickMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("messages.vpn-block").replaceAll("%IP%", vpnResult.getIpAddress()).replaceAll("%NAME%", preLoginEvent.getName()));
                preLoginEvent.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, kickMessage);
                return;
            }
        }
        if ((geoResultOptional = geoResultOptionalFuture.join()).isPresent() && !hasGeoExemptionPermission.booleanValue()) {
            GeoResult geoResult = (GeoResult)geoResultOptional.get();
            boolean isGeoFlagged = false;
            switch (ConnectionGuardSpigotPlugin.getInstance().getConfig().getString("behavior.geo.type").toLowerCase()) {
                case "blacklist": {
                    if (!ConnectionGuardSpigotPlugin.getInstance().getConfig().getStringList("behavior.geo.list").contains(geoResult.getCountryName())) break;
                    isGeoFlagged = true;
                    break;
                }
                case "whitelist": {
                    if (ConnectionGuardSpigotPlugin.getInstance().getConfig().getStringList("behavior.geo.list").contains(geoResult.getCountryName())) break;
                    isGeoFlagged = true;
                    break;
                }
                default: {
                    ConnectionGuard.getLogger().info("Invalid geo behavior type. Please use BLACKLIST or WHITELIST.");
                }
            }
            if (isGeoFlagged) {
                if (ConnectionGuardSpigotPlugin.getInstance().getConfig().getBoolean("behavior.geo.notify-staff")) {
                    String notifyMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("messages.geo-notify").replaceAll("%IP%", geoResult.getIpAddress()).replaceAll("%COUNTRY%", geoResult.getCountryName()).replaceAll("%CITY%", geoResult.getCityName()).replaceAll("%ISP%", geoResult.getIspName()).replaceAll("%NAME%", preLoginEvent.getName()));
                    Bukkit.broadcast((String)notifyMessage, (String)"connectionguard.notify.geo");
                }
                if (ConnectionGuardSpigotPlugin.getInstance().getConfig().getBoolean("behavior.geo.execute-command.enabled")) {
                    Bukkit.getScheduler().runTask((Plugin)ConnectionGuardSpigotPlugin.getInstance(), new Runnable(){

                        @Override
                        public void run() {
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)ConnectionGuardSpigotPlugin.getInstance().getConfig().getString("behavior.geo.execute-command.command").replaceAll("%NAME%", preLoginEvent.getName()).replaceAll("%IP%", ipAddress));
                        }
                    });
                }
                if (ConnectionGuardSpigotPlugin.getInstance().getConfig().getBoolean("behavior.geo.send-webhook.enabled")) {
                    String webhookMessage = ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("messages.geo-webhook").replaceAll("%NAME%", preLoginEvent.getName()).replaceAll("%IP%", ipAddress).replaceAll("%COUNTRY%", geoResult.getCountryName()).replaceAll("%CITY%", geoResult.getCityName()).replaceAll("%ISP%", geoResult.getIspName());
                    String webhookUrl = ConnectionGuardSpigotPlugin.getInstance().getConfig().getString("behavior.geo.send-webhook.url");
                    CGWebHookHelper.sendWebHook(webhookUrl, webhookMessage);
                }
                if (ConnectionGuardSpigotPlugin.getInstance().getConfig().getBoolean("behavior.geo.kick-player")) {
                    String kickMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("messages.geo-block").replaceAll("%IP%", geoResult.getIpAddress()).replaceAll("%COUNTRY%", geoResult.getCountryName()).replaceAll("%CITY%", geoResult.getCityName()).replaceAll("%ISP%", geoResult.getIspName()).replaceAll("%NAME%", preLoginEvent.getName()));
                    preLoginEvent.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, kickMessage);
                }
            }
        }
    }
}

