/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.velocity.commands;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.geo.GeoResult;
import com.github.gerolndnr.connectionguard.core.vpn.VpnResult;
import com.github.gerolndnr.connectionguard.velocity.ConnectionGuardVelocityPlugin;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class ConnectionGuardVelocityCommand
implements SimpleCommand {
    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource commandSender = invocation.source();
        String[] args = (String[])invocation.arguments();
        TextComponent noPermissionMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("command.no-permission"));
        if (args.length == 0) {
            if (!commandSender.hasPermission("connectionguard.command.help")) {
                commandSender.sendMessage((Component)noPermissionMessage);
                return;
            }
            this.sendHelpMessage(commandSender);
            return;
        }
        if (args.length == 1) {
            switch (args[0].toLowerCase()) {
                case "help": {
                    if (!commandSender.hasPermission("connectionguard.command.help")) {
                        commandSender.sendMessage((Component)noPermissionMessage);
                        return;
                    }
                    this.sendHelpMessage(commandSender);
                    return;
                }
                case "reload": {
                    if (!commandSender.hasPermission("connectionguard.command.reload")) {
                        commandSender.sendMessage((Component)noPermissionMessage);
                        return;
                    }
                    this.reloadPlugin(commandSender);
                    return;
                }
                case "clear": {
                    if (!commandSender.hasPermission("connectionguard.command.clear")) {
                        commandSender.sendMessage((Component)noPermissionMessage);
                        return;
                    }
                    this.clearCache(commandSender);
                    return;
                }
            }
            this.sendUnknownSubcommandMessage(commandSender);
            return;
        }
        if (args.length == 2) {
            switch (args[0].toLowerCase()) {
                case "clear": {
                    if (!commandSender.hasPermission("connectionguard.command.clear")) {
                        commandSender.sendMessage((Component)noPermissionMessage);
                        return;
                    }
                    this.clearCache(commandSender, args[1]);
                    return;
                }
                case "info": {
                    if (!commandSender.hasPermission("connectionguard.command.info")) {
                        commandSender.sendMessage((Component)noPermissionMessage);
                        return;
                    }
                    this.sendInformationMessage(commandSender, args[1]);
                    return;
                }
            }
            this.sendUnknownSubcommandMessage(commandSender);
            return;
        }
        this.sendUnknownSubcommandMessage(commandSender);
    }

    private void sendUnknownSubcommandMessage(CommandSource commandSender) {
        commandSender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("command.unknown-subcommand")));
    }

    private boolean sendInformationMessage(CommandSource commandSender, String entry) {
        CompletableFuture.runAsync(() -> {
            String queriedInput;
            String ipAddress;
            if (ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getPlayer(entry).isPresent()) {
                player = (Player)ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getPlayer(entry).get();
                ipAddress = player.getRemoteAddress().getAddress().getHostAddress();
                queriedInput = player.getUsername();
            } else {
                try {
                    player = (Player)ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getPlayer(UUID.fromString(entry)).get();
                    ipAddress = player.getRemoteAddress().getAddress().getHostAddress();
                    queriedInput = player.getUsername();
                }
                catch (Exception e) {
                    try {
                        queriedInput = ipAddress = InetAddress.getByName(entry).getHostAddress();
                    }
                    catch (UnknownHostException ex) {
                        commandSender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("messages.invalid-argument")));
                        return;
                    }
                }
            }
            VpnResult vpnResult = ConnectionGuard.getVpnResult(ipAddress).join();
            Optional<GeoResult> geoResultOptional = ConnectionGuard.getGeoResult(ipAddress).join();
            GeoResult geoResult = geoResultOptional.isPresent() ? geoResultOptional.get() : new GeoResult(ipAddress, "-", "-", "-");
            String isVpn = ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("messages.info.not-vpn");
            if (vpnResult.isVpn()) {
                isVpn = ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("messages.info.is-vpn");
            }
            for (String line : ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getStringList("messages.info.text")) {
                commandSender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(line.replaceAll("%INPUT%", queriedInput).replaceAll("%COUNTRY%", geoResult.getCountryName()).replaceAll("%CITY%", geoResult.getCityName()).replaceAll("%ISP%", geoResult.getIspName()).replaceAll("%IS_VPN%", isVpn).replaceAll("%IP%", ipAddress)));
            }
        });
        return true;
    }

    private boolean clearCache(CommandSource commandSender, String entry) {
        CompletableFuture.runAsync(() -> {
            String queriedInput;
            String ipAddress;
            if (ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getPlayer(entry).isPresent()) {
                Player player = (Player)ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getPlayer(entry).get();
                ipAddress = player.getRemoteAddress().getHostName();
                queriedInput = player.getUsername();
            } else {
                try {
                    Player player = (Player)ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getPlayer(UUID.fromString(entry)).get();
                    ipAddress = ((Player)ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getPlayer(UUID.fromString(entry)).get()).getRemoteAddress().getHostName();
                    queriedInput = player.getUsername();
                }
                catch (Exception e) {
                    try {
                        queriedInput = ipAddress = InetAddress.getByName(entry).getHostAddress();
                    }
                    catch (UnknownHostException ex) {
                        commandSender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("messages.invalid-argument")));
                        return;
                    }
                }
            }
            ConnectionGuard.getCacheProvider().removeGeoResult(ipAddress);
            ConnectionGuard.getCacheProvider().removeVpnResult(ipAddress);
            commandSender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("command.clear.clear-specific").replaceAll("%ENTRY%", queriedInput)));
        });
        return true;
    }

    private boolean clearCache(CommandSource commandSender) {
        ConnectionGuard.getCacheProvider().removeAllVpnResults();
        ConnectionGuard.getCacheProvider().removeAllGeoResults();
        commandSender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("command.clear.clear-all")));
        return true;
    }

    private boolean sendHelpMessage(CommandSource commandSender) {
        for (String line : ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getStringList("messages.help")) {
            commandSender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(line));
        }
        return true;
    }

    private boolean reloadPlugin(CommandSource commandSender) {
        try {
            ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().reload();
            ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().reload();
        }
        catch (IOException e) {
            ConnectionGuardVelocityPlugin.getInstance().getLogger().error("Boosted YAML | " + e.getMessage());
            return true;
        }
        commandSender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("command.config-reload").replace("&", "\u00a7")));
        return true;
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<String> proposals = new ArrayList<String>();
            String[] strings = (String[])invocation.arguments();
            CommandSource commandSender = invocation.source();
            if (strings.length == 1) {
                if (commandSender.hasPermission("connectionguard.command.help")) {
                    proposals.add("help");
                }
                if (commandSender.hasPermission("connectionguard.command.info")) {
                    proposals.add("info");
                }
                if (commandSender.hasPermission("connectionguard.command.clear")) {
                    proposals.add("clear");
                }
                if (commandSender.hasPermission("connectionguard.command.reload")) {
                    proposals.add("reload");
                }
            }
            if (strings.length == 2) {
                if (strings[0].equalsIgnoreCase("info")) {
                    proposals.add("1.1.1.1");
                    for (Player player : ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getAllPlayers()) {
                        proposals.add(player.getUsername());
                    }
                }
                if (strings[0].equalsIgnoreCase("clear")) {
                    proposals.add("1.1.1.1");
                    for (Player player : ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getAllPlayers()) {
                        proposals.add(player.getUsername());
                    }
                }
            }
            return proposals;
        });
    }
}

