/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.bungee;

import com.github.gerolndnr.connectionguard.bungee.commands.ConnectionGuardBungeeCommand;
import com.github.gerolndnr.connectionguard.bungee.listener.ConnectionGuardBungeeListener;
import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.cache.NoCacheProvider;
import com.github.gerolndnr.connectionguard.core.cache.RedisCacheProvider;
import com.github.gerolndnr.connectionguard.core.cache.SQLiteCacheProvider;
import com.github.gerolndnr.connectionguard.core.geo.IpApiGeoProvider;
import com.github.gerolndnr.connectionguard.core.geo.ProxyCheckGeoProvider;
import com.github.gerolndnr.connectionguard.core.vpn.IpApiVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.IpHubVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.ProxyCheckVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.VpnApiVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.VpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.custom.CustomVpnProvider;
import com.github.gerolndnr.connectionguard.libs.com.alessiodp.libby.BungeeLibraryManager;
import com.github.gerolndnr.connectionguard.libs.com.alessiodp.libby.Library;
import com.github.gerolndnr.connectionguard.libs.org.bstats.bungeecord.Metrics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class ConnectionGuardBungeePlugin
extends Plugin {
    private static ConnectionGuardBungeePlugin connectionGuardBungeePlugin;
    private File configFile;
    private File languageFile;
    private Configuration config;
    private Configuration languageConfig;
    private HashMap<String, VpnProvider> vpnProviderMap;

    public void onEnable() {
        connectionGuardBungeePlugin = this;
        this.vpnProviderMap = new HashMap();
        ConnectionGuard.setLogger(this.getLogger());
        File translationFolder = this.getDataFolder().toPath().resolve("translation").toFile();
        if (!translationFolder.exists()) {
            translationFolder.mkdirs();
        }
        this.configFile = new File(this.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            try {
                InputStream in = ConnectionGuardBungeePlugin.class.getResourceAsStream("/config.yml");
                Files.copy(in, this.configFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                this.getLogger().info("Connection Guard | " + e.getMessage());
                return;
            }
        }
        try {
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.configFile);
        }
        catch (IOException e) {
            this.getLogger().info("Connection Guard | " + e.getMessage());
        }
        String selectedLanguageFileName = this.config.getString("message-language") + ".yml";
        this.languageFile = new File(this.getDataFolder().toPath().resolve("translation").toFile(), selectedLanguageFileName);
        if (!this.languageFile.exists()) {
            try {
                InputStream in = ConnectionGuardBungeePlugin.class.getResourceAsStream("/translation/en.yml");
                Files.copy(in, this.languageFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                this.getLogger().info("Connection Guard | " + e.getMessage());
                return;
            }
        }
        try {
            this.languageConfig = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.languageFile);
        }
        catch (IOException e) {
            this.getLogger().info("Connection Guard | " + e.getMessage());
            return;
        }
        BungeeLibraryManager libraryManager = new BungeeLibraryManager(this);
        Library httpLibrary = Library.builder().groupId("com.squareup.okhttp3").artifactId("okhttp").version("4.12.0").resolveTransitiveDependencies(true).build();
        Library gsonLibrary = Library.builder().groupId("com.google.code.gson").artifactId("gson").version("2.11.0").resolveTransitiveDependencies(true).relocate("com{}google{}gson", "com{}github{}gerolndnr{}connectionguard{}libs{}com{}google{}gson").build();
        Library bstatsLibrary = Library.builder().groupId("org#bstats".replaceAll("#", ".")).artifactId("bstats-bungeecord").version("3.0.2").resolveTransitiveDependencies(true).relocate("org{}bstats", "com{}github{}gerolndnr{}connectionguard{}libs{}org{}bstats").build();
        libraryManager.addMavenCentral();
        libraryManager.loadLibrary(httpLibrary);
        libraryManager.loadLibrary(gsonLibrary);
        libraryManager.loadLibrary(bstatsLibrary);
        switch (this.getConfig().getString("provider.cache.type").toLowerCase()) {
            case "sqlite": {
                Library sqliteLibrary = Library.builder().groupId("org.xerial").artifactId("sqlite-jdbc").version("3.46.0.0").resolveTransitiveDependencies(true).build();
                libraryManager.loadLibrary(sqliteLibrary);
                ConnectionGuard.setCacheProvider(new SQLiteCacheProvider(new File(this.getDataFolder(), "cache.db").getAbsolutePath()));
                break;
            }
            case "redis": {
                Library jedisLibrary = Library.builder().groupId("redis.clients").artifactId("jedis").version("5.0.0").resolveTransitiveDependencies(true).build();
                libraryManager.loadLibrary(jedisLibrary);
                ConnectionGuard.setCacheProvider(new RedisCacheProvider(this.getConfig().getString("provider.cache.redis.hostname"), this.getConfig().getInt("provider.cache.redis.port"), this.getConfig().getString("provider.cache.redis.username"), this.getConfig().getString("provider.cache.redis.password")));
                break;
            }
            case "disabled": {
                ConnectionGuard.setCacheProvider(new NoCacheProvider());
                break;
            }
            default: {
                this.getLogger().info("The specified cache provider is invalid. Please use SQLite,Redis or disable the cache.");
                return;
            }
        }
        ConnectionGuard.getCacheProvider().setup();
        this.vpnProviderMap.put("proxycheck", new ProxyCheckVpnProvider(this.getConfig().getString("provider.vpn.proxycheck.api-key")));
        this.vpnProviderMap.put("ip-api", new IpApiVpnProvider());
        this.vpnProviderMap.put("iphub", new IpHubVpnProvider(this.getConfig().getString("provider.vpn.iphub.api-key")));
        this.vpnProviderMap.put("vpnapi", new VpnApiVpnProvider(this.getConfig().getString("provider.vpn.vpnapi.api-key")));
        ArrayList<VpnProvider> vpnProviders = new ArrayList<VpnProvider>();
        for (String key : this.getConfig().getSection("provider.vpn").getKeys()) {
            if (!this.getConfig().getBoolean("provider.vpn." + key + ".enabled")) continue;
            if (this.vpnProviderMap.get(key) != null) {
                vpnProviders.add(this.vpnProviderMap.get(key));
            } else {
                vpnProviders.add(new CustomVpnProvider(this.getConfig().getString("provider.vpn." + key + ".request-type"), this.getConfig().getString("provider.vpn." + key + ".request-url"), this.getConfig().getStringList("provider.vpn." + key + ".request-header"), this.getConfig().getString("provider.vpn." + key + ".request-body-type"), this.getConfig().getString("provider.vpn." + key + ".request-body"), this.getConfig().getString("provider.vpn." + key + ".response-type"), this.getConfig().getString("provider.vpn." + key + ".response-format.is-vpn-field.field-name"), this.getConfig().getString("provider.vpn." + key + ".response-format.is-vpn-field.field-type"), this.getConfig().getString("provider.vpn." + key + ".response-format.is-vpn-field.string-options.is-vpn-string"), this.getConfig().getString("provider.vpn." + key + ".response-format.vpn-provider-field.field-name")));
            }
            ConnectionGuard.getLogger().info("Registered vpn detection provider '" + key + "'.");
        }
        ConnectionGuard.setVpnProviders(vpnProviders);
        switch (this.getConfig().getString("provider.geo.service").toLowerCase()) {
            case "ip-api": {
                ConnectionGuard.setGeoProvider(new IpApiGeoProvider());
                break;
            }
            case "proxycheck": {
                ConnectionGuard.setGeoProvider(new ProxyCheckGeoProvider(this.getConfig().getString("provider.vpn.proxycheck.api-key")));
                break;
            }
            default: {
                this.getLogger().info("The specified geo provider is invalid. Please use IP-API.");
            }
        }
        ConnectionGuard.setRequiredPositiveFlags(this.getConfig().getInt("required-positive-flags"));
        ConnectionGuard.setVpnCacheExpirationTime(this.getConfig().getInt("provider.cache.expiration.vpn"));
        ConnectionGuard.setGeoCacheExpirationTime(this.getConfig().getInt("provider.cache.expiration.geo"));
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ConnectionGuardBungeeListener());
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ConnectionGuardBungeeCommand());
        Metrics metrics = new Metrics((Plugin)this, 22912);
    }

    public void onDisable() {
        ConnectionGuard.getCacheProvider().disband();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void reloadAllConfigs() {
        try {
            this.languageConfig = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.languageFile);
        }
        catch (IOException e) {
            this.getLogger().info("Connection Guard | " + e.getMessage());
        }
        try {
            this.languageConfig = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.languageFile);
        }
        catch (IOException e) {
            this.getLogger().info("Connection Guard | " + e.getMessage());
        }
    }

    public Configuration getLanguageConfig() {
        return this.languageConfig;
    }

    public static ConnectionGuardBungeePlugin getInstance() {
        return connectionGuardBungeePlugin;
    }
}

