/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.core.cache;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.cache.CacheProvider;
import com.github.gerolndnr.connectionguard.core.geo.GeoResult;
import com.github.gerolndnr.connectionguard.core.vpn.VpnResult;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.Gson;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import redis.clients.jedis.JedisPooled;

public class RedisCacheProvider
implements CacheProvider {
    private String hostname;
    private int port;
    private String username;
    private String password;
    private JedisPooled jedisPooled;

    public RedisCacheProvider(String hostname, int port, String username, String password) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    @Override
    public CompletableFuture<Boolean> setup() {
        return CompletableFuture.supplyAsync(() -> {
            this.jedisPooled = new JedisPooled(this.hostname, this.port, null, this.password);
            String pong = this.jedisPooled.ping();
            if (pong.equalsIgnoreCase("pong")) {
                return true;
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<Boolean> disband() {
        return CompletableFuture.supplyAsync(() -> {
            this.jedisPooled.close();
            return true;
        });
    }

    @Override
    public CompletableFuture<Optional<VpnResult>> getVpnResult(String ipAddress) {
        return CompletableFuture.supplyAsync(() -> {
            String vpnResultRaw = this.jedisPooled.hget("connectionguard.vpn", ipAddress);
            if (vpnResultRaw == null) {
                return Optional.empty();
            }
            Gson gson = new Gson();
            VpnResult vpnResult = (VpnResult)gson.fromJson(vpnResultRaw, VpnResult.class);
            if (vpnResult.getCachedOn() + (long)(ConnectionGuard.getVpnCacheExpirationTime() * 60 * 1000) > new Date().getTime()) {
                return Optional.of(vpnResult);
            }
            this.jedisPooled.hdel("connectionguard.vpn", new String[]{ipAddress});
            return Optional.empty();
        });
    }

    @Override
    public CompletableFuture<Optional<GeoResult>> getGeoResult(String ipAddress) {
        return CompletableFuture.supplyAsync(() -> {
            String geoResultRaw = this.jedisPooled.hget("connectionguard.geo", ipAddress);
            if (geoResultRaw == null) {
                return Optional.empty();
            }
            Gson gson = new Gson();
            GeoResult geoResult = (GeoResult)gson.fromJson(geoResultRaw, GeoResult.class);
            if (geoResult.getCachedOn() + (long)(ConnectionGuard.getVpnCacheExpirationTime() * 60 * 1000) > new Date().getTime()) {
                return Optional.of(geoResult);
            }
            this.jedisPooled.hdel("connectionguard.geo", new String[]{ipAddress});
            return Optional.empty();
        });
    }

    @Override
    public CompletableFuture<Void> addVpnResult(VpnResult vpnResult) {
        return CompletableFuture.runAsync(() -> {
            VpnResult vpnResult1 = vpnResult;
            vpnResult1.setCachedOn(new Date().getTime());
            Gson gson = new Gson();
            this.jedisPooled.hset("connectionguard.vpn", vpnResult.getIpAddress(), gson.toJson((Object)vpnResult1));
        });
    }

    @Override
    public CompletableFuture<Void> addGeoResult(GeoResult geoResult) {
        return CompletableFuture.runAsync(() -> {
            GeoResult geoResult1 = geoResult;
            geoResult1.setCachedOn(new Date().getTime());
            Gson gson = new Gson();
            this.jedisPooled.hset("connectionguard.vpn", "connectionguard.geo." + geoResult.getIpAddress(), gson.toJson((Object)geoResult1));
        });
    }

    @Override
    public CompletableFuture<Boolean> removeVpnResult(String ipAddress) {
        return CompletableFuture.supplyAsync(() -> {
            this.jedisPooled.hdel("connectionguard.vpn", new String[]{ipAddress});
            return true;
        });
    }

    @Override
    public CompletableFuture<Boolean> removeGeoResult(String ipAddress) {
        return CompletableFuture.supplyAsync(() -> {
            this.jedisPooled.hdel("connectionguard.geo", new String[]{ipAddress});
            return true;
        });
    }

    @Override
    public CompletableFuture<Boolean> removeAllVpnResults() {
        return CompletableFuture.supplyAsync(() -> {
            this.jedisPooled.del("connectionguard.vpn");
            return true;
        });
    }

    @Override
    public CompletableFuture<Boolean> removeAllGeoResults() {
        return CompletableFuture.supplyAsync(() -> {
            this.jedisPooled.del("connectionguard.geo");
            return true;
        });
    }
}

