/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.core.geo;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.geo.GeoProvider;
import com.github.gerolndnr.connectionguard.core.geo.GeoResult;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.JsonObject;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class IpApiGeoProvider
implements GeoProvider {
    @Override
    public CompletableFuture<Optional<GeoResult>> getGeoResult(String ipAddress) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject jsonObject;
            OkHttpClient httpClient = new OkHttpClient();
            Request request = new Request.Builder().url("http://ip-api.com/json/" + ipAddress + "?fields=status,message,countryCode,city,isp").build();
            try {
                Response response = httpClient.newCall(request).execute();
                jsonObject = JsonParser.parseString((String)response.body().string()).getAsJsonObject();
            }
            catch (IOException e) {
                ConnectionGuard.getLogger().info("IP-API | " + e.getMessage());
                return Optional.empty();
            }
            String status = jsonObject.get("status").getAsString();
            String countryCode = jsonObject.get("countryCode").getAsString();
            String cityName = jsonObject.get("city").getAsString();
            String ispName = jsonObject.get("isp").getAsString();
            if (status.equalsIgnoreCase("fail")) {
                String message = jsonObject.get("message").getAsString();
                ConnectionGuard.getLogger().info("IP-API | " + message);
                return Optional.empty();
            }
            return Optional.of(new GeoResult(ipAddress, countryCode, cityName, ispName));
        });
    }
}

