/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.core.vpn;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.vpn.VpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.VpnResult;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.JsonElement;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.JsonObject;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class IpApiVpnProvider
implements VpnProvider {
    @Override
    public CompletableFuture<Optional<VpnResult>> getVpnResult(String ipAddress) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject jsonObject;
            Response response;
            OkHttpClient httpClient = new OkHttpClient();
            Request request = new Request.Builder().url("http://ip-api.com/json/" + ipAddress + "?fields=proxy").build();
            boolean isProxy = false;
            try {
                response = httpClient.newCall(request).execute();
                jsonObject = JsonParser.parseString((String)response.body().string()).getAsJsonObject();
            }
            catch (IOException e) {
                ConnectionGuard.getLogger().info("IP-API | " + e.getMessage());
                return Optional.empty();
            }
            if (response.code() != 200) {
                String message = jsonObject.get("message").getAsString();
                ConnectionGuard.getLogger().info("IP-API | " + message);
                return Optional.empty();
            }
            JsonElement isProxyElement = jsonObject.get("proxy");
            if (isProxyElement == null) {
                ConnectionGuard.getLogger().info("IP-API | There is no 'proxy'-Element in the response of IP-API.");
            } else {
                isProxy = jsonObject.get("proxy").getAsBoolean();
            }
            if (isProxy) {
                return Optional.of(new VpnResult(ipAddress, true));
            }
            return Optional.of(new VpnResult(ipAddress, false));
        });
    }
}

