/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.core.vpn;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.vpn.VpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.VpnResult;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.JsonObject;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ProxyCheckVpnProvider
implements VpnProvider {
    private String apiKey;

    public ProxyCheckVpnProvider(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public CompletableFuture<Optional<VpnResult>> getVpnResult(String ipAddress) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject jsonObject;
            Response response;
            OkHttpClient httpClient = new OkHttpClient();
            Request request = new Request.Builder().url("http://proxycheck.io/v2/" + ipAddress + "?key=" + this.apiKey + "&vpn=1").build();
            try {
                response = httpClient.newCall(request).execute();
            }
            catch (IOException e) {
                ConnectionGuard.getLogger().info("Could not execute GET request on proxycheck vpn provider.");
                return Optional.empty();
            }
            try {
                jsonObject = JsonParser.parseString((String)response.body().string()).getAsJsonObject();
            }
            catch (IOException e) {
                ConnectionGuard.getLogger().info("Could not turn response body of proxycheck vpn provider into a string.");
                return Optional.empty();
            }
            String requestStatus = jsonObject.get("status").getAsString();
            switch (requestStatus.toLowerCase()) {
                case "ok": {
                    break;
                }
                case "warning": {
                    ConnectionGuard.getLogger().info("ProxyCheck | " + jsonObject.get("message").getAsString());
                    break;
                }
                case "denied": {
                    ConnectionGuard.getLogger().info("ProxyCheck | " + jsonObject.get("message").getAsString());
                    return Optional.empty();
                }
                case "error": {
                    ConnectionGuard.getLogger().info("ProxyCheck | " + jsonObject.get("message").getAsString());
                    return Optional.empty();
                }
            }
            String isVpn = jsonObject.get(ipAddress).getAsJsonObject().get("proxy").getAsString();
            if (isVpn.equalsIgnoreCase("yes")) {
                return Optional.of(new VpnResult(ipAddress, true));
            }
            return Optional.of(new VpnResult(ipAddress, false));
        });
    }
}

