/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.core.webhook;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.webhook.CGWebHookRequest;
import com.github.gerolndnr.connectionguard.libs.com.google.gson.Gson;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class CGWebHookHelper {
    public static CompletableFuture<Void> sendWebHook(String url, String content) {
        return CompletableFuture.runAsync(() -> {
            OkHttpClient httpClient = new OkHttpClient();
            Gson gson = new Gson();
            String jsonRequest = gson.toJson((Object)new CGWebHookRequest(content));
            RequestBody requestBody = RequestBody.create((String)jsonRequest, (MediaType)MediaType.get((String)"application/json"));
            Request request = new Request.Builder().url(url).post(requestBody).build();
            try {
                Response response = httpClient.newCall(request).execute();
                if (response.code() != 204) {
                    ConnectionGuard.getLogger().info("WebHook | " + response.message());
                }
            }
            catch (IOException e) {
                ConnectionGuard.getLogger().info("WebHook | " + e.getMessage());
            }
        });
    }
}

