/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.spigot.commands;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.geo.GeoResult;
import com.github.gerolndnr.connectionguard.core.vpn.VpnResult;
import com.github.gerolndnr.connectionguard.spigot.ConnectionGuardSpigotPlugin;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class ConnectionGuardSpigotCommand
implements TabExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] args) {
        String noPermissionMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("command.no-permission"));
        if (args.length == 0) {
            if (!commandSender.hasPermission("connectionguard.command.help")) {
                commandSender.sendMessage(noPermissionMessage);
                return true;
            }
            return this.sendHelpMessage(commandSender);
        }
        if (args.length == 1) {
            switch (args[0].toLowerCase()) {
                case "help": {
                    if (!commandSender.hasPermission("connectionguard.command.help")) {
                        commandSender.sendMessage(noPermissionMessage);
                        return true;
                    }
                    return this.sendHelpMessage(commandSender);
                }
                case "reload": {
                    if (!commandSender.hasPermission("connectionguard.command.reload")) {
                        commandSender.sendMessage(noPermissionMessage);
                        return true;
                    }
                    return this.reloadPlugin(commandSender);
                }
                case "clear": {
                    if (!commandSender.hasPermission("connectionguard.command.clear")) {
                        commandSender.sendMessage(noPermissionMessage);
                        return true;
                    }
                    return this.clearCache(commandSender);
                }
            }
            return this.sendUnknownSubcommandMessage(commandSender);
        }
        if (args.length == 2) {
            switch (args[0].toLowerCase()) {
                case "clear": {
                    if (!commandSender.hasPermission("connectionguard.command.clear")) {
                        commandSender.sendMessage(noPermissionMessage);
                        return true;
                    }
                    return this.clearCache(commandSender, args[1]);
                }
                case "info": {
                    if (!commandSender.hasPermission("connectionguard.command.info")) {
                        commandSender.sendMessage(noPermissionMessage);
                        return true;
                    }
                    return this.sendInformationMessage(commandSender, args[1]);
                }
            }
            return this.sendUnknownSubcommandMessage(commandSender);
        }
        return this.sendUnknownSubcommandMessage(commandSender);
    }

    private boolean sendUnknownSubcommandMessage(CommandSender commandSender) {
        commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("command.unknown-subcommand")));
        return true;
    }

    private boolean sendInformationMessage(CommandSender commandSender, String entry) {
        CompletableFuture.runAsync(() -> {
            String queriedInput;
            String ipAddress;
            Player player;
            if (Bukkit.getPlayer((String)entry) != null) {
                player = Bukkit.getPlayer((String)entry);
                ipAddress = player.getAddress().getAddress().getHostAddress();
                queriedInput = player.getName();
            } else {
                try {
                    player = Bukkit.getPlayer((UUID)UUID.fromString(entry));
                    ipAddress = Bukkit.getPlayer((UUID)UUID.fromString(entry)).getAddress().getAddress().getHostAddress();
                    queriedInput = player.getName();
                }
                catch (Exception e) {
                    try {
                        queriedInput = ipAddress = InetAddress.getByName(entry).getHostAddress();
                    }
                    catch (UnknownHostException ex) {
                        commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("messages.invalid-argument")));
                        return;
                    }
                }
            }
            VpnResult vpnResult = ConnectionGuard.getVpnResult(ipAddress).join();
            Optional<GeoResult> geoResultOptional = ConnectionGuard.getGeoResult(ipAddress).join();
            GeoResult geoResult = geoResultOptional.isPresent() ? geoResultOptional.get() : new GeoResult(ipAddress, "-", "-", "-");
            String isVpn = ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("messages.info.not-vpn"));
            if (vpnResult.isVpn()) {
                isVpn = ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("messages.info.is-vpn"));
            }
            for (String line : ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getStringList("messages.info.text")) {
                commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)line.replaceAll("%INPUT%", queriedInput).replaceAll("%COUNTRY%", geoResult.getCountryName()).replaceAll("%CITY%", geoResult.getCityName()).replaceAll("%ISP%", geoResult.getIspName()).replaceAll("%IS_VPN%", isVpn).replaceAll("%IP%", ipAddress)));
            }
        });
        return true;
    }

    private boolean clearCache(CommandSender commandSender, String entry) {
        CompletableFuture.runAsync(() -> {
            String queriedInput;
            String ipAddress;
            if (Bukkit.getPlayer((String)entry) != null) {
                Player player = Bukkit.getPlayer((String)entry);
                ipAddress = player.getAddress().getHostName();
                queriedInput = player.getName();
            } else {
                try {
                    Player player = Bukkit.getPlayer((UUID)UUID.fromString(entry));
                    ipAddress = Bukkit.getPlayer((UUID)UUID.fromString(entry)).getAddress().getHostName();
                    queriedInput = player.getName();
                }
                catch (Exception e) {
                    try {
                        queriedInput = ipAddress = InetAddress.getByName(entry).getHostAddress();
                    }
                    catch (UnknownHostException ex) {
                        commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("messages.invalid-argument")));
                        return;
                    }
                }
            }
            ConnectionGuard.getCacheProvider().removeGeoResult(ipAddress);
            ConnectionGuard.getCacheProvider().removeVpnResult(ipAddress);
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("command.clear.clear-specific").replaceAll("%ENTRY%", queriedInput)));
        });
        return true;
    }

    private boolean clearCache(CommandSender commandSender) {
        ConnectionGuard.getCacheProvider().removeAllVpnResults();
        ConnectionGuard.getCacheProvider().removeAllGeoResults();
        commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("command.clear.clear-all")));
        return true;
    }

    private boolean sendHelpMessage(CommandSender commandSender) {
        for (String line : ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getStringList("messages.help")) {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        return true;
    }

    private boolean reloadPlugin(CommandSender commandSender) {
        ConnectionGuardSpigotPlugin.getInstance().reloadAllConfigs();
        commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)ConnectionGuardSpigotPlugin.getInstance().getLanguageConfig().getString("command.config-reload")));
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] strings) {
        ArrayList<String> proposals = new ArrayList<String>();
        if (strings.length == 1) {
            if (commandSender.hasPermission("connectionguard.command.help")) {
                proposals.add("help");
            }
            if (commandSender.hasPermission("connectionguard.command.info")) {
                proposals.add("info");
            }
            if (commandSender.hasPermission("connectionguard.command.clear")) {
                proposals.add("clear");
            }
            if (commandSender.hasPermission("connectionguard.command.reload")) {
                proposals.add("reload");
            }
        }
        if (strings.length == 2) {
            if (strings[0].equalsIgnoreCase("info")) {
                proposals.add("1.1.1.1");
                for (Player player : Bukkit.getOnlinePlayers()) {
                    proposals.add(player.getName());
                }
            }
            if (strings[0].equalsIgnoreCase("clear")) {
                proposals.add("1.1.1.1");
                for (Player player : Bukkit.getOnlinePlayers()) {
                    proposals.add(player.getName());
                }
            }
        }
        return proposals;
    }
}

