/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.velocity;

import com.github.gerolndnr.connectionguard.velocity.ConnectionGuardVelocityPlugin;
import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.settings.Settings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;

public class CGVelocityConfig {
    private File configFile;
    private File languageFile;
    private YamlDocument config;
    private YamlDocument languageConfig;
    private Path dataDirectory;

    public CGVelocityConfig(Path dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public void load() {
        File translationFolder = this.dataDirectory.resolve("translation").toFile();
        if (!translationFolder.exists()) {
            translationFolder.mkdirs();
        }
        this.configFile = new File(this.dataDirectory.toFile(), "config.yml");
        if (!this.configFile.exists()) {
            try {
                InputStream in = ConnectionGuardVelocityPlugin.class.getResourceAsStream("/config.yml");
                Files.copy(in, this.configFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                ConnectionGuardVelocityPlugin.getInstance().getLogger().error("Connection Guard | " + e.getMessage());
                return;
            }
        }
        try {
            this.config = YamlDocument.create((File)this.configFile, (Settings[])new Settings[]{GeneralSettings.builder().setUseDefaults(true).build()});
        }
        catch (IOException e) {
            ConnectionGuardVelocityPlugin.getInstance().getLogger().error("Connection Guard | " + e.getMessage());
        }
        String selectedLanguageFileName = this.config.getString("message-language") + ".yml";
        this.languageFile = new File(this.dataDirectory.resolve("translation").toFile(), selectedLanguageFileName);
        if (!this.languageFile.exists()) {
            try {
                InputStream in = ConnectionGuardVelocityPlugin.class.getResourceAsStream("/translation/en.yml");
                Files.copy(in, this.languageFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                ConnectionGuardVelocityPlugin.getInstance().getLogger().error("Connection Guard | " + e.getMessage());
                return;
            }
        }
        try {
            this.languageConfig = YamlDocument.create((File)this.languageFile, (Settings[])new Settings[]{GeneralSettings.builder().setUseDefaults(true).build()});
        }
        catch (IOException e) {
            ConnectionGuardVelocityPlugin.getInstance().getLogger().error("Connection Guard | " + e.getMessage());
            return;
        }
    }

    public YamlDocument getLanguageConfig() {
        return this.languageConfig;
    }

    public YamlDocument getConfig() {
        return this.config;
    }
}

