/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.velocity;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.cache.NoCacheProvider;
import com.github.gerolndnr.connectionguard.core.cache.RedisCacheProvider;
import com.github.gerolndnr.connectionguard.core.cache.SQLiteCacheProvider;
import com.github.gerolndnr.connectionguard.core.geo.IpApiGeoProvider;
import com.github.gerolndnr.connectionguard.core.geo.ProxyCheckGeoProvider;
import com.github.gerolndnr.connectionguard.core.vpn.IpApiVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.IpHubVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.ProxyCheckVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.VpnApiVpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.VpnProvider;
import com.github.gerolndnr.connectionguard.core.vpn.custom.CustomVpnProvider;
import com.github.gerolndnr.connectionguard.libs.com.alessiodp.libby.Library;
import com.github.gerolndnr.connectionguard.libs.com.alessiodp.libby.VelocityLibraryManager;
import com.github.gerolndnr.connectionguard.velocity.CGVelocityConfig;
import com.github.gerolndnr.connectionguard.velocity.commands.ConnectionGuardVelocityCommand;
import com.github.gerolndnr.connectionguard.velocity.listener.ConnectionGuardVelocityListener;
import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;

@Plugin(id="connection-guard", name="Connection Guard", version="0.4.9", url="https://github.com/gerolndnr/connection-guard", authors={"gerolndnr"})
public class ConnectionGuardVelocityPlugin {
    private final ProxyServer proxyServer;
    private final Logger logger;
    private final Path dataDirectory;
    private CGVelocityConfig cgVelocityConfig;
    private static ConnectionGuardVelocityPlugin connectionGuardVelocityPlugin;
    private HashMap<String, VpnProvider> vpnProviderMap;

    @Inject
    public ConnectionGuardVelocityPlugin(ProxyServer proxyServer, Logger logger, @DataDirectory Path dataDirectory) {
        this.proxyServer = proxyServer;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.vpnProviderMap = new HashMap();
        connectionGuardVelocityPlugin = this;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent initializeEvent) {
        ConnectionGuard.setLogger(java.util.logging.Logger.getLogger(this.logger.getName()));
        VelocityLibraryManager<ConnectionGuardVelocityPlugin> libraryManager = new VelocityLibraryManager<ConnectionGuardVelocityPlugin>(this, this.logger, this.dataDirectory, this.proxyServer.getPluginManager());
        Library boostedYamlLibrary = Library.builder().groupId("dev.dejvokep").artifactId("boosted-yaml").version("1.3.6").resolveTransitiveDependencies(true).relocate("dev.defvokep.boostedyaml", "com.github.gerolndnr.connectionguard.libs.dev.defvokep.boostedyaml").build();
        Library httpLibrary = Library.builder().groupId("com.squareup.okhttp3").artifactId("okhttp").version("4.12.0").resolveTransitiveDependencies(true).build();
        Library gsonLibrary = Library.builder().groupId("com.google.code.gson").artifactId("gson").version("2.11.0").resolveTransitiveDependencies(true).relocate("com{}google{}gson", "com{}github{}gerolndnr{}connectionguard{}libs{}com{}google{}gson").build();
        Library bstatsLibrary = Library.builder().groupId("org#bstats".replaceAll("#", ".")).artifactId("bstats-velocity").version("3.0.2").resolveTransitiveDependencies(true).relocate("org{}bstats", "com{}github{}gerolndnr{}connectionguard{}libs{}org{}bstats").build();
        libraryManager.addMavenCentral();
        libraryManager.loadLibrary(boostedYamlLibrary);
        libraryManager.loadLibrary(httpLibrary);
        libraryManager.loadLibrary(gsonLibrary);
        libraryManager.loadLibrary(bstatsLibrary);
        this.cgVelocityConfig = new CGVelocityConfig(this.dataDirectory);
        this.cgVelocityConfig.load();
        switch (this.cgVelocityConfig.getConfig().getString("provider.cache.type").toLowerCase()) {
            case "sqlite": {
                Library sqliteLibrary = Library.builder().groupId("org.xerial").artifactId("sqlite-jdbc").version("3.46.0.0").resolveTransitiveDependencies(true).build();
                libraryManager.loadLibrary(sqliteLibrary);
                ConnectionGuard.setCacheProvider(new SQLiteCacheProvider(new File(this.dataDirectory.toFile(), "cache.db").getAbsolutePath()));
                break;
            }
            case "redis": {
                Library jedisLibrary = Library.builder().groupId("redis.clients").artifactId("jedis").version("5.0.0").resolveTransitiveDependencies(true).build();
                libraryManager.loadLibrary(jedisLibrary);
                ConnectionGuard.setCacheProvider(new RedisCacheProvider(this.getCgVelocityConfig().getConfig().getString("provider.cache.redis.hostname"), this.getCgVelocityConfig().getConfig().getInt("provider.cache.redis.port"), this.getCgVelocityConfig().getConfig().getString("provider.cache.redis.username"), this.getCgVelocityConfig().getConfig().getString("provider.cache.redis.password")));
                break;
            }
            case "disabled": {
                ConnectionGuard.setCacheProvider(new NoCacheProvider());
                break;
            }
            default: {
                this.logger.error("The specified cache provider is invalid. Please use SQLite,Redis or disable the cache.");
                return;
            }
        }
        ConnectionGuard.getCacheProvider().setup();
        this.vpnProviderMap.put("proxycheck", new ProxyCheckVpnProvider(this.getCgVelocityConfig().getConfig().getString("provider.vpn.proxycheck.api-key")));
        this.vpnProviderMap.put("ip-api", new IpApiVpnProvider());
        this.vpnProviderMap.put("iphub", new IpHubVpnProvider(this.getCgVelocityConfig().getConfig().getString("provider.vpn.iphub.api-key")));
        this.vpnProviderMap.put("vpnapi", new VpnApiVpnProvider(this.getCgVelocityConfig().getConfig().getString("provider.vpn.vpnapi.api-key")));
        ArrayList<VpnProvider> vpnProviders = new ArrayList<VpnProvider>();
        for (Object keyObject : this.getCgVelocityConfig().getConfig().getSection("provider.vpn").getKeys()) {
            String key = keyObject.toString();
            if (!this.getCgVelocityConfig().getConfig().getBoolean("provider.vpn." + key + ".enabled").booleanValue()) continue;
            if (this.vpnProviderMap.get(key) != null) {
                vpnProviders.add(this.vpnProviderMap.get(key));
            } else {
                vpnProviders.add(new CustomVpnProvider(this.getCgVelocityConfig().getConfig().getString("provider.vpn." + key + ".request-type"), this.getCgVelocityConfig().getConfig().getString("provider.vpn." + key + ".request-url"), this.getCgVelocityConfig().getConfig().getStringList("provider.vpn." + key + ".request-header"), this.getCgVelocityConfig().getConfig().getString("provider.vpn." + key + ".request-body-type"), this.getCgVelocityConfig().getConfig().getString("provider.vpn." + key + ".request-body"), this.getCgVelocityConfig().getConfig().getString("provider.vpn." + key + ".response-type"), this.getCgVelocityConfig().getConfig().getString("provider.vpn." + key + ".response-format.is-vpn-field.field-name"), this.getCgVelocityConfig().getConfig().getString("provider.vpn." + key + ".response-format.is-vpn-field.field-type"), this.getCgVelocityConfig().getConfig().getString("provider.vpn." + key + ".response-format.is-vpn-field.string-options.is-vpn-string"), this.getCgVelocityConfig().getConfig().getString("provider.vpn." + key + ".response-format.vpn-provider-field.field-name")));
            }
            ConnectionGuard.getLogger().info("Registered vpn detection provider '" + key + "'.");
        }
        ConnectionGuard.setVpnProviders(vpnProviders);
        switch (this.cgVelocityConfig.getConfig().getString("provider.geo.service").toLowerCase()) {
            case "ip-api": {
                ConnectionGuard.setGeoProvider(new IpApiGeoProvider());
                break;
            }
            case "proxycheck": {
                ConnectionGuard.setGeoProvider(new ProxyCheckGeoProvider(this.getCgVelocityConfig().getConfig().getString("provider.vpn.proxycheck.api-key")));
                break;
            }
            default: {
                this.logger.info("The specified geo provider is invalid. Please use IP-API.");
            }
        }
        ConnectionGuard.setRequiredPositiveFlags(this.cgVelocityConfig.getConfig().getInt("required-positive-flags"));
        ConnectionGuard.setVpnCacheExpirationTime(this.cgVelocityConfig.getConfig().getInt("provider.cache.expiration.vpn"));
        ConnectionGuard.setGeoCacheExpirationTime(this.cgVelocityConfig.getConfig().getInt("provider.cache.expiration.geo"));
        this.proxyServer.getEventManager().register((Object)this, (Object)new ConnectionGuardVelocityListener());
        CommandMeta commandMeta = this.proxyServer.getCommandManager().metaBuilder("connectionguard").aliases(new String[]{"cg"}).plugin((Object)this).build();
        ConnectionGuardVelocityCommand simpleCommand = new ConnectionGuardVelocityCommand();
        this.proxyServer.getCommandManager().register(commandMeta, (Command)simpleCommand);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public CGVelocityConfig getCgVelocityConfig() {
        return this.cgVelocityConfig;
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public static ConnectionGuardVelocityPlugin getInstance() {
        return connectionGuardVelocityPlugin;
    }
}

