/*
 * Decompiled with CFR 0.152.
 */
package com.github.gerolndnr.connectionguard.velocity.listener;

import com.github.gerolndnr.connectionguard.core.ConnectionGuard;
import com.github.gerolndnr.connectionguard.core.geo.GeoResult;
import com.github.gerolndnr.connectionguard.core.luckperms.CGLuckPermsHelper;
import com.github.gerolndnr.connectionguard.core.vpn.VpnResult;
import com.github.gerolndnr.connectionguard.core.webhook.CGWebHookHelper;
import com.github.gerolndnr.connectionguard.velocity.ConnectionGuardVelocityPlugin;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.proxy.Player;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class ConnectionGuardVelocityListener {
    @Subscribe
    public EventTask onPreLogin(PreLoginEvent loginEvent) {
        String ipAddress = loginEvent.getConnection().getRemoteAddress().getHostString();
        String playerUuid = loginEvent.getUniqueId().toString();
        String playerUsername = loginEvent.getUsername();
        CompletableFuture<VpnResult> vpnResultFuture = ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getStringList("behavior.vpn.exemptions").contains(ipAddress) || ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getStringList("behavior.vpn.exemptions").contains(playerUuid) || ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getStringList("behavior.vpn.exemptions").contains(playerUsername) ? CompletableFuture.completedFuture(new VpnResult(ipAddress, false)) : ConnectionGuard.getVpnResult(ipAddress);
        CompletableFuture<Optional<Object>> geoResultOptionalFuture = ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getStringList("behavior.geo.exemptions").contains(ipAddress) || ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getStringList("behavior.geo.exemptions").contains(playerUuid) || ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getStringList("behavior.geo.exemptions").contains(playerUsername) ? CompletableFuture.completedFuture(Optional.empty()) : ConnectionGuard.getGeoResult(ipAddress);
        return EventTask.async(() -> {
            VpnResult vpnResult = (VpnResult)vpnResultFuture.join();
            Optional geoResultOptional = (Optional)geoResultOptionalFuture.join();
            if (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getBoolean("behavior.vpn.use-permission-exemption").booleanValue() && CGLuckPermsHelper.hasPermission(loginEvent.getUniqueId(), "connectionguard.exemption.vpn").join().booleanValue()) {
                vpnResult = new VpnResult(ipAddress, false);
            }
            if (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getBoolean("behavior.geo.use-permission-exemption").booleanValue() && CGLuckPermsHelper.hasPermission(loginEvent.getUniqueId(), "connectionguard.exemption.geo").join().booleanValue()) {
                geoResultOptional = Optional.empty();
            }
            if (vpnResult.isVpn()) {
                if (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getBoolean("behavior.vpn.notify-staff").booleanValue()) {
                    TextComponent notifyMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("messages.vpn-notify").replaceAll("%IP%", vpnResult.getIpAddress()).replaceAll("%NAME%", playerUsername));
                    this.broadcastMessage((Component)notifyMessage, "connectionguard.notify.vpn");
                }
                if (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getBoolean("behavior.vpn.execute-command.enabled").booleanValue()) {
                    ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getCommandManager().executeAsync((CommandSource)ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getConsoleCommandSource(), ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getString("behavior.vpn.execute-command.command").replaceAll("%NAME%", playerUsername).replaceAll("%IP%", ipAddress));
                }
                if (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getBoolean("behavior.vpn.send-webhook.enabled").booleanValue()) {
                    String webhookMessage = ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("messages.vpn-webhook").replaceAll("%NAME%", playerUsername).replaceAll("%IP%", ipAddress);
                    String webhookUrl = ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getString("behavior.vpn.send-webhook.url");
                    CGWebHookHelper.sendWebHook(webhookUrl, webhookMessage);
                }
                if (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getBoolean("behavior.vpn.kick-player").booleanValue()) {
                    TextComponent kickMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("messages.vpn-block").replaceAll("%IP%", vpnResult.getIpAddress()).replaceAll("%NAME%", playerUsername));
                    loginEvent.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)kickMessage));
                    return;
                }
            }
            if (geoResultOptional.isPresent()) {
                GeoResult geoResult = (GeoResult)geoResultOptional.get();
                boolean isGeoFlagged = false;
                switch (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getString("behavior.geo.type").toLowerCase()) {
                    case "blacklist": {
                        if (!ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getStringList("behavior.geo.list").contains(geoResult.getCountryName())) break;
                        isGeoFlagged = true;
                        break;
                    }
                    case "whitelist": {
                        if (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getStringList("behavior.geo.list").contains(geoResult.getCountryName())) break;
                        isGeoFlagged = true;
                        break;
                    }
                    default: {
                        ConnectionGuard.getLogger().info("Invalid geo behavior type. Please use BLACKLIST or WHITELIST.");
                    }
                }
                if (isGeoFlagged) {
                    if (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getBoolean("behavior.geo.notify-staff").booleanValue()) {
                        TextComponent notifyMessage = LegacyComponentSerializer.legacySection().deserialize(ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("messages.geo-notify").replaceAll("%IP%", geoResult.getIpAddress()).replaceAll("%COUNTRY%", geoResult.getCountryName()).replaceAll("%CITY%", geoResult.getCityName()).replaceAll("%ISP%", geoResult.getIspName()).replaceAll("%NAME%", playerUsername));
                        this.broadcastMessage((Component)notifyMessage, "connectionguard.notify.geo");
                    }
                    if (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getBoolean("behavior.geo.execute-command.enabled").booleanValue()) {
                        ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getCommandManager().executeAsync((CommandSource)ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getConsoleCommandSource(), ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getString("behavior.geo.execute-command.command").replaceAll("%NAME%", playerUsername).replaceAll("%IP%", ipAddress).replaceAll("%COUNTRY%", geoResult.getCountryName()));
                    }
                    if (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getBoolean("behavior.geo.send-webhook.enabled").booleanValue()) {
                        String webhookMessage = ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("messages.geo-webhook").replaceAll("%NAME%", playerUsername).replaceAll("%IP%", ipAddress).replaceAll("%COUNTRY%", geoResult.getCountryName()).replaceAll("%CITY%", geoResult.getCityName()).replaceAll("%ISP%", geoResult.getIspName());
                        String webhookUrl = ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getString("behavior.geo.send-webhook.url");
                        CGWebHookHelper.sendWebHook(webhookUrl, webhookMessage);
                    }
                    if (ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getConfig().getBoolean("behavior.geo.kick-player").booleanValue()) {
                        TextComponent kickMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(ConnectionGuardVelocityPlugin.getInstance().getCgVelocityConfig().getLanguageConfig().getString("messages.geo-block").replaceAll("%IP%", geoResult.getIpAddress()).replaceAll("%COUNTRY%", geoResult.getCountryName()).replaceAll("%CITY%", geoResult.getCityName()).replaceAll("%ISP%", geoResult.getIspName()).replaceAll("%NAME%", playerUsername));
                        loginEvent.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)kickMessage));
                        return;
                    }
                }
                loginEvent.setResult(PreLoginEvent.PreLoginComponentResult.allowed());
            }
        });
    }

    private void broadcastMessage(Component message, String permission) {
        for (Player player : ConnectionGuardVelocityPlugin.getInstance().getProxyServer().getAllPlayers()) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(message);
        }
    }
}

