/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib;

import com.github.darksoulq.abyssallib.common.config.internal.PluginConfig;
import com.github.darksoulq.abyssallib.common.util.FileUtils;
import com.github.darksoulq.abyssallib.common.util.Metrics;
import com.github.darksoulq.abyssallib.server.HookConstants;
import com.github.darksoulq.abyssallib.server.bridge.BlockBridge;
import com.github.darksoulq.abyssallib.server.bridge.ItemBridge;
import com.github.darksoulq.abyssallib.server.chat.ChatInputHandler;
import com.github.darksoulq.abyssallib.server.data.Datapack;
import com.github.darksoulq.abyssallib.server.event.EventBus;
import com.github.darksoulq.abyssallib.server.event.internal.BlockEvents;
import com.github.darksoulq.abyssallib.server.event.internal.EntityEvents;
import com.github.darksoulq.abyssallib.server.event.internal.GuiEvents;
import com.github.darksoulq.abyssallib.server.event.internal.ItemEvents;
import com.github.darksoulq.abyssallib.server.event.internal.PackEvent;
import com.github.darksoulq.abyssallib.server.event.internal.PlayerEvents;
import com.github.darksoulq.abyssallib.server.event.internal.ServerEvents;
import com.github.darksoulq.abyssallib.server.resource.Namespace;
import com.github.darksoulq.abyssallib.server.resource.PackServer;
import com.github.darksoulq.abyssallib.server.resource.ResourcePack;
import com.github.darksoulq.abyssallib.server.resource.asset.Lang;
import com.github.darksoulq.abyssallib.server.resource.asset.Model;
import com.github.darksoulq.abyssallib.server.resource.asset.Texture;
import com.github.darksoulq.abyssallib.server.resource.asset.definition.Selector;
import com.github.darksoulq.abyssallib.server.resource.asset.definition.Tint;
import com.github.darksoulq.abyssallib.server.resource.util.TextOffset;
import com.github.darksoulq.abyssallib.world.block.internal.BlockManager;
import com.github.darksoulq.abyssallib.world.entity.DamageType;
import com.github.darksoulq.abyssallib.world.entity.internal.EntityManager;
import com.github.darksoulq.abyssallib.world.gui.GuiManager;
import com.github.darksoulq.abyssallib.world.gui.internal.GuiTextures;
import com.github.darksoulq.abyssallib.world.item.Items;
import com.github.darksoulq.abyssallib.world.item.component.Components;
import com.github.darksoulq.abyssallib.world.recipe.RecipeLoader;
import java.io.File;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class AbyssalLib
extends JavaPlugin {
    public static final String MODID = "abyssallib";
    private static AbyssalLib INSTANCE;
    public static Logger LOGGER;
    public static PluginConfig CONFIG;
    public static PackServer PACK_SERVER;
    public static EventBus EVENT_BUS;
    public static DamageType.Registrar DAMAGE_TYPE_REGISTRAR;
    public static Datapack.Registrar DATAPACK_REGISTRAR;

    public void onEnable() {
        INSTANCE = this;
        LOGGER = this.getLogger();
        HookConstants.load();
        ItemBridge.setup();
        BlockBridge.setup();
        Components.DATA_COMPONENTS_VANILLA.apply();
        Components.DATA_COMPONENTS.apply();
        Items.ITEMS.apply();
        new BukkitRunnable(){

            public void run() {
                int saved = BlockManager.save();
                AbyssalLib.this.getLogger().info("Saved " + saved + " blocks");
            }
        }.runTaskTimerAsynchronously((Plugin)this, 2400L, 6000L);
        CONFIG = new PluginConfig();
        AbyssalLib.CONFIG.cfg.save();
        FileUtils.createDirectories(new File(this.getDataFolder(), "recipes"));
        RecipeLoader.loadFolder(new File(AbyssalLib.getInstance().getDataFolder(), "recipes"));
        new BukkitRunnable(this){

            public void run() {
                for (World world : Bukkit.getWorlds()) {
                    try {
                        EntityManager.runSpawnCycle(world);
                    }
                    catch (CloneNotSupportedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }.runTaskTimer((Plugin)this, 100L, 100L);
        EVENT_BUS = new EventBus((Plugin)this);
        EVENT_BUS.register(new ChatInputHandler());
        EVENT_BUS.register(new PlayerEvents());
        EVENT_BUS.register(new EntityEvents());
        EVENT_BUS.register(new BlockEvents());
        EVENT_BUS.register(new ItemEvents());
        EVENT_BUS.register(new ServerEvents());
        EVENT_BUS.register(new GuiEvents());
        GuiManager.init((Plugin)this);
        if (AbyssalLib.CONFIG.rp.enabled.get().booleanValue()) {
            EVENT_BUS.register(new PackEvent());
            PACK_SERVER = new PackServer();
            PACK_SERVER.start(AbyssalLib.CONFIG.rp.ip.get(), AbyssalLib.CONFIG.rp.port.get());
        }
        if (AbyssalLib.CONFIG.metrics.get().booleanValue()) {
            new Metrics((Plugin)this, 25772);
        }
        ResourcePack rp = new ResourcePack((Plugin)this, MODID);
        Namespace ns = rp.namespace(MODID);
        ns.icon();
        TextOffset.init(ns);
        GuiTextures.init(ns);
        this.createItemDef("invisible", ns);
        this.createItemDef("forward", ns);
        this.createItemDef("backward", ns);
        Lang lang = ns.lang("en_us", false);
        lang.put("item.abyssallib.invisible", "");
        lang.put("item.abyssallib.forward", "Forward");
        lang.put("item.abyssallib.backward", "Backward");
        lang.put("plugin.abyssallib", "AbyssalLib");
        rp.register(false);
    }

    public void onDisable() {
        BlockManager.save();
        if (PACK_SERVER != null) {
            PACK_SERVER.stop();
        }
    }

    public static AbyssalLib getInstance() {
        return INSTANCE;
    }

    private void createItemDef(String name, Namespace ns) {
        Texture tex = ns.texture("item/" + name);
        Model model = ns.model(name, false);
        model.parent("minecraft:item/generated");
        model.texture("layer0", tex);
        Selector.Model sel = new Selector.Model(model, new Tint[0]);
        ns.itemDefinition(name, sel, false);
    }
}

