/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.config.legacy;

import com.github.darksoulq.abyssallib.common.config.legacy.ConfigParser;
import com.github.darksoulq.abyssallib.common.config.legacy.ConfigSpec;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = Paths.get("config", new String[0]);
    private static final Map<String, ConfigSpec> CONFIGS = new HashMap<String, ConfigSpec>();

    public static ConfigSpec register(String modId, ConfigSpec spec) {
        CONFIGS.put(modId, spec);
        Config.load(modId, spec);
        return spec;
    }

    private static void load(String key, ConfigSpec spec) {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            Path path = CONFIG_DIR.resolve(key + ".json");
            if (Files.exists(path, new LinkOption[0])) {
                JsonObject json = JsonParser.parseReader((Reader)new FileReader(path.toFile())).getAsJsonObject();
                Map<String, JsonElement> flat = Config.flatten(json, "");
                for (Map.Entry<String, JsonElement> entry : flat.entrySet()) {
                    ConfigSpec.ConfigType type;
                    Object parsed = ConfigParser.parseValue(entry.getValue());
                    if (parsed == null || (type = spec.getDefinitionType(entry.getKey())) == null) continue;
                    spec.set(type, entry.getKey(), parsed);
                }
            } else {
                Config.save(key, spec);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config: " + key, e);
        }
    }

    public static ConfigSpec get(String modid) {
        return CONFIGS.get(modid);
    }

    public static void reloadAll() {
        CONFIGS.forEach(Config::load);
    }

    public static void saveAll() {
        CONFIGS.forEach(Config::save);
    }

    private static void save(String key, ConfigSpec spec) {
        Path path = CONFIG_DIR.resolve(key + ".json");
        JsonObject root = new JsonObject();
        for (Map.Entry<String, Object> entry : spec.getAllValues().entrySet()) {
            String[] parts = entry.getKey().split("\\.");
            JsonObject current = root;
            for (int i = 0; i < parts.length - 1; ++i) {
                String part = parts[i];
                if (!current.has(part) || !current.get(part).isJsonObject()) {
                    current.add(part, (JsonElement)new JsonObject());
                }
                current = current.getAsJsonObject(part);
            }
            String lastKey = parts[parts.length - 1];
            Object value = entry.getValue();
            JsonElement serialized = ConfigParser.serializeValue(value);
            if (serialized == null) continue;
            current.add(lastKey, serialized);
        }
        try (FileWriter writer = new FileWriter(path.toFile());){
            GSON.toJson((JsonElement)root, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config: " + key, e);
        }
    }

    private static Map<String, JsonElement> flatten(JsonObject obj, String prefix) {
        HashMap<String, JsonElement> result = new HashMap<String, JsonElement>();
        for (Map.Entry entry : obj.entrySet()) {
            String key = prefix.isEmpty() ? (String)entry.getKey() : prefix + "." + (String)entry.getKey();
            JsonElement val = (JsonElement)entry.getValue();
            if (val.isJsonObject()) {
                result.putAll(Config.flatten(val.getAsJsonObject(), key));
                continue;
            }
            result.put(key, val);
        }
        return result;
    }

    public static Set<String> getAllModIDs() {
        return CONFIGS.keySet();
    }
}

