/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.database.impl.sqlite;

import com.github.darksoulq.abyssallib.common.database.Database;
import com.github.darksoulq.abyssallib.common.database.QueryExecutor;
import com.github.darksoulq.abyssallib.common.database.impl.sqlite.SqliteQueryExecutor;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;

public class SqliteDatabase
implements Database {
    private final File file;
    private Connection connection;

    public SqliteDatabase(File file) {
        this.file = file;
    }

    @Override
    public void connect() throws Exception {
        this.file.getParentFile().mkdirs();
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.file.getAbsolutePath());
    }

    @Override
    public void disconnect() throws Exception {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    @Override
    public QueryExecutor executor() {
        return new SqliteQueryExecutor(this.connection);
    }
}

