/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.database.impl.sqlite;

import com.github.darksoulq.abyssallib.common.database.ResultMapper;
import com.github.darksoulq.abyssallib.common.database.TableBuilder;
import com.github.darksoulq.abyssallib.common.database.TableQuery;
import com.github.darksoulq.abyssallib.common.database.impl.sqlite.SqliteTableBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class SqliteTableQuery
implements TableQuery {
    private final Connection conn;
    private final String table;
    private String type = "INSERT";
    private final Map<String, Object> values = new LinkedHashMap<String, Object>();
    private String whereClause = null;
    private Object[] whereParams = new Object[0];

    public SqliteTableQuery(Connection conn, String table) {
        this.conn = conn;
        this.table = table;
    }

    @Override
    public TableQuery insert() {
        this.type = "INSERT";
        return this;
    }

    @Override
    public TableQuery update() {
        this.type = "UPDATE";
        return this;
    }

    @Override
    public TableQuery delete() {
        this.type = "DELETE";
        return this;
    }

    @Override
    public TableBuilder create() {
        return new SqliteTableBuilder(this.conn, this.table);
    }

    @Override
    public TableQuery value(String column, Object value) {
        this.values.put(column, value);
        return this;
    }

    @Override
    public TableQuery where(String clause, Object ... params) {
        this.whereClause = clause;
        this.whereParams = params;
        return this;
    }

    @Override
    public int execute() {
        try {
            return switch (this.type) {
                case "INSERT" -> this.executeInsert();
                case "UPDATE" -> this.executeUpdate();
                case "DELETE" -> this.executeDelete();
                default -> 0;
            };
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private int executeInsert() throws SQLException {
        StringBuilder sql = new StringBuilder("INSERT OR REPLACE INTO " + this.table + " (");
        StringJoiner cols = new StringJoiner(", ");
        StringJoiner placeholders = new StringJoiner(", ");
        for (String col : this.values.keySet()) {
            cols.add(col);
            placeholders.add("?");
        }
        sql.append(cols).append(") VALUES (").append(placeholders).append(")");
        try (PreparedStatement stmt = this.conn.prepareStatement(sql.toString());){
            this.setValues(stmt, this.values.values().toArray());
            int n = stmt.executeUpdate();
            return n;
        }
    }

    private int executeUpdate() throws SQLException {
        StringBuilder sql = new StringBuilder("UPDATE " + this.table + " SET ");
        StringJoiner updates = new StringJoiner(", ");
        for (String col : this.values.keySet()) {
            updates.add(col + " = ?");
        }
        sql.append(updates);
        if (this.whereClause != null) {
            sql.append(" WHERE ").append(this.whereClause);
        }
        try (PreparedStatement stmt = this.conn.prepareStatement(sql.toString());){
            ArrayList<Object> all = new ArrayList<Object>(this.values.values());
            all.addAll(List.of(this.whereParams));
            this.setValues(stmt, all.toArray());
            int n = stmt.executeUpdate();
            return n;
        }
    }

    private int executeDelete() throws SQLException {
        StringBuilder sql = new StringBuilder("DELETE FROM " + this.table);
        if (this.whereClause != null) {
            sql.append(" WHERE ").append(this.whereClause);
        }
        try (PreparedStatement stmt = this.conn.prepareStatement(sql.toString());){
            this.setValues(stmt, this.whereParams);
            int n = stmt.executeUpdate();
            return n;
        }
    }

    @Override
    public <T> List<T> select(ResultMapper<T> mapper) {
        ArrayList<T> results = new ArrayList<T>();
        StringBuilder sql = new StringBuilder("SELECT * FROM " + this.table);
        if (this.whereClause != null) {
            sql.append(" WHERE ").append(this.whereClause);
        }
        try (PreparedStatement stmt = this.conn.prepareStatement(sql.toString());){
            this.setValues(stmt, this.whereParams);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                results.add(mapper.map(rs));
            }
        }
        catch (ClassNotFoundException | CloneNotSupportedException | SQLException e) {
            throw new RuntimeException(e);
        }
        return results;
    }

    private void setValues(PreparedStatement stmt, Object[] values) throws SQLException {
        for (int i = 0; i < values.length; ++i) {
            stmt.setObject(i + 1, values[i]);
        }
    }
}

