/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.serialization;

import com.github.darksoulq.abyssallib.common.serialization.DynamicOps;
import com.github.darksoulq.abyssallib.common.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Codec<T> {
    public <D> T decode(DynamicOps<D> var1, D var2) throws CodecException;

    public <D> D encode(DynamicOps<D> var1, T var2) throws CodecException;

    public static <T> Codec<T> of(final Function<Object, T> decoder, final Function<T, Object> encoder) {
        return new Codec<T>(){

            @Override
            public <D> T decode(DynamicOps<D> ops, D input) throws CodecException {
                try {
                    return decoder.apply(input);
                }
                catch (Exception e) {
                    throw new CodecException("Failed to decode", e);
                }
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, T value) throws CodecException {
                try {
                    return (D)encoder.apply(value);
                }
                catch (Exception e) {
                    throw new CodecException("Failed to encode", e);
                }
            }
        };
    }

    default public <R> Codec<R> xmap(final CheckedFunction<? super T, ? extends R> forward, final CheckedFunction<? super R, ? extends T> backward) {
        final Codec self = this;
        return new Codec<R>(this){

            @Override
            public <D> R decode(DynamicOps<D> ops, D input) throws CodecException {
                return forward.apply(self.decode(ops, input));
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, R value) throws CodecException {
                return self.encode(ops, backward.apply(value));
            }
        };
    }

    default public Codec<T> orElse(final T defaultValue) {
        final Codec self = this;
        return new Codec<T>(this){

            @Override
            public <D> T decode(DynamicOps<D> ops, D input) {
                try {
                    Object result = self.decode(ops, input);
                    return result != null ? result : defaultValue;
                }
                catch (CodecException e) {
                    return defaultValue;
                }
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, T value) throws CodecException {
                return self.encode(ops, value != null ? value : defaultValue);
            }
        };
    }

    default public Codec<List<T>> list() {
        return this.collection(ArrayList::new);
    }

    default public <U> Codec<U> unchecked() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <C extends Collection<T>> Codec<C> collection(final Supplier<C> factory) {
        final Codec self = this;
        if (self instanceof FallbackCodec) {
            FallbackCodec fallbackCodec = (FallbackCodec)self;
            try {
                Codec codec;
                Codec left = codec = fallbackCodec.left();
                Codec right = codec = fallbackCodec.right();
                Codec leftList = left.list().unchecked();
                Codec rightList = right.list().unchecked();
                return new FallbackCodec(leftList, rightList).unchecked();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (!(self instanceof OneOfCodec)) {
            return new Codec<C>(this){

                @Override
                public <D> C decode(DynamicOps<D> ops, D input) throws CodecException {
                    List<D> rawList = ops.getList(input).orElseThrow(() -> new CodecException("Expected list for collection"));
                    Collection result = (Collection)factory.get();
                    for (D elem : rawList) {
                        result.add(self.decode(ops, elem));
                    }
                    return result;
                }

                @Override
                public <D> D encode(DynamicOps<D> ops, C value) throws CodecException {
                    ArrayList<D> result = new ArrayList<D>(value.size());
                    for (Object elem : value) {
                        result.add(self.encode(ops, elem));
                    }
                    return ops.createList(result);
                }
            };
        }
        OneOfCodec many = (OneOfCodec)self;
        ArrayList listCodecs = new ArrayList();
        Iterator iterator = many.codecs().iterator();
        while (iterator.hasNext()) {
            Codec c = iterator.next();
            listCodecs.add(c.list().unchecked());
        }
        return new OneOfCodec(listCodecs).unchecked();
    }

    default public Codec<Optional<T>> optional() {
        final Codec self = this;
        return new Codec<Optional<T>>(this){

            @Override
            public <D> Optional<T> decode(DynamicOps<D> ops, D input) throws CodecException {
                if (input == null || Objects.equals(input, ops.empty())) {
                    return Optional.empty();
                }
                return Optional.ofNullable(self.decode(ops, input));
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, Optional<T> value) throws CodecException {
                if (value.isEmpty()) {
                    return ops.empty();
                }
                return self.encode(ops, value.get());
            }
        };
    }

    default public Codec<T> nullable() {
        final Codec self = this;
        return new Codec<T>(this){

            @Override
            public <D> T decode(DynamicOps<D> ops, D input) throws CodecException {
                D empty = ops.empty();
                if (input == null || Objects.equals(input, empty)) {
                    return null;
                }
                return self.decode(ops, input);
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, T value) throws CodecException {
                return value == null ? ops.empty() : self.encode(ops, value);
            }
        };
    }

    public static <K, V> Codec<Map<K, V>> map(final Codec<K> keyCodec, final Codec<V> valueCodec) {
        return new Codec<Map<K, V>>(){

            @Override
            public <D> Map<K, V> decode(DynamicOps<D> ops, D input) throws CodecException {
                Map<D, D> raw = ops.getMap(input).orElseThrow(() -> new CodecException("Expected map"));
                LinkedHashMap result = new LinkedHashMap(raw.size());
                for (Map.Entry<D, D> e : raw.entrySet()) {
                    Object k = keyCodec.decode(ops, e.getKey());
                    Object v = valueCodec.decode(ops, e.getValue());
                    result.put(k, v);
                }
                return result;
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, Map<K, V> value) throws CodecException {
                LinkedHashMap<D, D> result = new LinkedHashMap<D, D>(value.size());
                for (Map.Entry e : value.entrySet()) {
                    result.put(keyCodec.encode(ops, e.getKey()), valueCodec.encode(ops, e.getValue()));
                }
                return ops.createMap(result);
            }
        };
    }

    public static <E extends Enum<E>> Codec<E> enumCodec(final Class<E> enumClass) {
        return new Codec<E>(){

            @Override
            public <D> E decode(DynamicOps<D> ops, D input) throws CodecException {
                String name = ops.getStringValue(input).orElseThrow(() -> new CodecException("Expected enum string"));
                try {
                    return Enum.valueOf(enumClass, name);
                }
                catch (IllegalArgumentException e) {
                    throw new CodecException("Invalid enum value: " + name);
                }
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, E value) {
                return ops.createString(((Enum)value).name());
            }
        };
    }

    public static <T> Codec<T> fallback(Codec<? extends T> left, Codec<? extends T> right) {
        return new FallbackCodec(left.unchecked(), right.unchecked());
    }

    public static <A, B> Codec<Either<A, B>> either(Codec<A> left, Codec<B> right) {
        return new EitherCodec<A, B>(left, right);
    }

    @SafeVarargs
    public static <T> Codec<T> oneOf(Codec<? extends T> ... codecs) {
        ArrayList list = new ArrayList();
        for (Codec<T> codec : codecs) {
            list.add(codec.unchecked());
        }
        return new OneOfCodec(list);
    }

    default public <P> Field<P, T> fieldOf(String name, Function<P, T> getter) {
        return new Field<P, T>(name, this, getter);
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws CodecException;
    }

    public record FallbackCodec<T>(Codec<T> left, Codec<T> right) implements Codec<T>
    {
        @Override
        public <D> T decode(DynamicOps<D> ops, D input) throws CodecException {
            try {
                return this.left.decode(ops, input);
            }
            catch (Exception ignored) {
                return this.right.decode(ops, input);
            }
        }

        @Override
        public <D> D encode(DynamicOps<D> ops, T value) throws CodecException {
            try {
                return this.left.encode(ops, value);
            }
            catch (Exception ignored) {
                return this.right.encode(ops, value);
            }
        }
    }

    public static final class OneOfCodec<T>
    implements Codec<T> {
        private final List<Codec<T>> codecs;

        public OneOfCodec(List<Codec<T>> codecs) {
            this.codecs = List.copyOf(codecs);
        }

        @Override
        public <D> T decode(DynamicOps<D> ops, D input) throws CodecException {
            CodecException last = null;
            for (Codec<T> c : this.codecs) {
                try {
                    return c.decode(ops, input);
                }
                catch (Exception e) {
                    last = new CodecException(e.getMessage(), e);
                }
            }
            throw last != null ? last : new CodecException("No codec in OneOf matched");
        }

        @Override
        public <D> D encode(DynamicOps<D> ops, T value) throws CodecException {
            CodecException last = null;
            for (Codec<T> c : this.codecs) {
                try {
                    return c.encode(ops, value);
                }
                catch (Exception e) {
                    last = new CodecException(e.getMessage(), e);
                }
            }
            throw last != null ? last : new CodecException("No codec in OneOf could encode");
        }

        public List<Codec<T>> codecs() {
            return this.codecs;
        }
    }

    public record EitherCodec<A, B>(Codec<A> left, Codec<B> right) implements Codec<Either<A, B>>
    {
        @Override
        public <D> Either<A, B> decode(DynamicOps<D> ops, D input) throws CodecException {
            try {
                return new Either.Left(this.left.decode(ops, input));
            }
            catch (Exception ignore) {
                return new Either.Right(this.right.decode(ops, input));
            }
        }

        @Override
        public <D> D encode(DynamicOps<D> ops, Either<A, B> either) throws CodecException {
            if (either instanceof Either.Left) {
                Either.Left l = (Either.Left)either;
                return this.left.encode(ops, l.value());
            }
            return this.right.encode(ops, ((Either.Right)either).value());
        }
    }

    public record Field<T, A>(String name, Codec<A> codec, Function<T, A> getter) {
    }

    public static class CodecException
    extends Exception {
        public CodecException(String message) {
            super(message);
        }

        public CodecException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

