/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.serialization;

import com.github.darksoulq.abyssallib.common.serialization.Codec;
import com.github.darksoulq.abyssallib.common.serialization.DynamicOps;
import com.github.darksoulq.abyssallib.common.serialization.RecordCodecBuilder;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.github.darksoulq.abyssallib.server.bridge.ItemBridge;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.potion.PotionMix;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.TransmuteRecipe;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.inventory.recipe.CraftingBookCategory;

public class Codecs {
    public static final Codec<Object> PASSTHROUGH = new Codec<Object>(){

        @Override
        public <D> Object decode(DynamicOps<D> ops, D input) {
            return input;
        }

        @Override
        public <D> D encode(DynamicOps<D> ops, Object value) {
            return (D)value;
        }
    };
    public static final Codec<String> STRING = new Codec<String>(){

        @Override
        public <D> String decode(DynamicOps<D> ops, D input) throws Codec.CodecException {
            return ops.getStringValue(input).orElseThrow(() -> new Codec.CodecException("Expected string"));
        }

        @Override
        public <D> D encode(DynamicOps<D> ops, String value) {
            return ops.createString(value);
        }
    };
    public static final Codec<Identifier> IDENTIFIER = STRING.xmap(Identifier::of, Identifier::toString);
    public static final Codec<Character> CHARACTER = STRING.xmap(str -> Character.valueOf(str.charAt(0)), String::valueOf);
    public static final Codec<Integer> INT = new Codec<Integer>(){

        @Override
        public <D> Integer decode(DynamicOps<D> ops, D input) throws Codec.CodecException {
            return ops.getIntValue(input).orElseThrow(() -> new Codec.CodecException("Expected integer"));
        }

        @Override
        public <D> D encode(DynamicOps<D> ops, Integer value) {
            return ops.createInt(value);
        }
    };
    public static final Codec<Long> LONG = new Codec<Long>(){

        @Override
        public <D> Long decode(DynamicOps<D> ops, D input) throws Codec.CodecException {
            return ops.getLongValue(input).orElseThrow(() -> new Codec.CodecException("Expected long"));
        }

        @Override
        public <D> D encode(DynamicOps<D> ops, Long value) {
            return ops.createLong(value);
        }
    };
    public static final Codec<Double> DOUBLE = new Codec<Double>(){

        @Override
        public <D> Double decode(DynamicOps<D> ops, D input) throws Codec.CodecException {
            return ops.getDoubleValue(input).orElseThrow(() -> new Codec.CodecException("Expected double"));
        }

        @Override
        public <D> D encode(DynamicOps<D> ops, Double value) {
            return ops.createDouble(value);
        }
    };
    public static final Codec<Float> FLOAT = new Codec<Float>(){

        @Override
        public <D> Float decode(DynamicOps<D> ops, D input) throws Codec.CodecException {
            return ops.getFloatValue(input).orElseThrow(() -> new Codec.CodecException("Expected float"));
        }

        @Override
        public <D> D encode(DynamicOps<D> ops, Float value) {
            return ops.createFloat(value.floatValue());
        }
    };
    public static final Codec<Boolean> BOOLEAN = new Codec<Boolean>(){

        @Override
        public <D> Boolean decode(DynamicOps<D> ops, D input) throws Codec.CodecException {
            return ops.getBooleanValue(input).orElseThrow(() -> new Codec.CodecException("Expected boolean"));
        }

        @Override
        public <D> D encode(DynamicOps<D> ops, Boolean value) {
            return ops.createBoolean(value);
        }
    };
    public static final Codec<UUID> UUID = STRING.xmap(UUID::fromString, UUID::toString);
    public static final Codec<Component> TEXT_COMPONENT = STRING.xmap(arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).deserialize(arg_0), arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).serialize(arg_0));
    public static final Codec<Key> KEY = STRING.xmap(Key::key, Key::asString);
    public static final Codec<NamespacedKey> NAMESPACED_KEY = STRING.xmap(NamespacedKey::fromString, NamespacedKey::toString);
    public static final Codec<World> WORLD = KEY.xmap(Bukkit::getWorld, RegionAccessor::getKey);
    public static final Codec<Location> LOCATION = RecordCodecBuilder.create(WORLD.fieldOf("world", Location::getWorld), DOUBLE.fieldOf("x", Location::getX), DOUBLE.fieldOf("y", Location::getY), DOUBLE.fieldOf("z", Location::getZ), FLOAT.fieldOf("yaw", Location::getYaw), FLOAT.fieldOf("pitch", Location::getPitch), Location::new);
    public static final Codec<DataComponentType> DATA_COMPONENT_TYPE = KEY.xmap(arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.DATA_COMPONENT_TYPE)).getOrThrow(arg_0), arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.DATA_COMPONENT_TYPE)).getKeyOrThrow(arg_0));
    public static final Codec<ItemStack> ITEM_STACK = Codec.fallback(RecordCodecBuilder.create(STRING.fieldOf("id", ItemBridge::getIdAsString), INT.optional().fieldOf("amount", i -> Optional.of(i.getAmount())), Codec.map(STRING, PASSTHROUGH.optional()).optional().fieldOf("data", i -> {
        Identifier id = ItemBridge.getId(i);
        if (id == null) {
            return Optional.empty();
        }
        ItemStack o = ItemBridge.get(id.toString());
        return i.equals((Object)o) ? Optional.empty() : Optional.of(ItemBridge.serializeData(i));
    }), (itemId, amount, components) -> {
        ItemStack stack = ItemBridge.get(itemId);
        if (stack == null) {
            throw new Codec.CodecException("Item ID not available in ItemBridge");
        }
        amount.ifPresent(arg_0 -> ((ItemStack)stack).setAmount(arg_0));
        components.ifPresent(c -> ItemBridge.deserializeData(c, stack));
        return stack;
    }), STRING.xmap(ItemBridge::get, ItemBridge::getIdAsString));
    public static final Codec<RecipeChoice.ExactChoice> EXACT_CHOICE = ITEM_STACK.list().xmap(RecipeChoice.ExactChoice::new, RecipeChoice.ExactChoice::getChoices);
    public static final Codec<RecipeChoice.MaterialChoice> MATERIAL_CHOICE = ITEM_STACK.list().xmap(list -> new RecipeChoice.MaterialChoice(list.stream().map(ItemStack::getType).toList()), mats -> mats.getChoices().stream().map(ItemStack::of).toList());
    public static final Codec<RecipeChoice> RECIPE_CHOICE = Codec.fallback(EXACT_CHOICE, MATERIAL_CHOICE);
    public static final Codec<ShapedRecipe> SHAPED_RECIPE = RecordCodecBuilder.create(NAMESPACED_KEY.fieldOf("id", CraftingRecipe::getKey), STRING.list().fieldOf("shape", o -> TextUtil.convertToList(o.getShape())), Codec.map(CHARACTER, RECIPE_CHOICE).fieldOf("ingredients", ShapedRecipe::getChoiceMap), ITEM_STACK.fieldOf("result", CraftingRecipe::getResult), STRING.optional().fieldOf("group", s -> Optional.of(s.getGroup())), Codec.enumCodec(CraftingBookCategory.class).optional().fieldOf("category", s -> Optional.of(s.getCategory())), (id, shape, ing, result, group, category) -> {
        ShapedRecipe recipe = new ShapedRecipe(id, result);
        recipe.shape(TextUtil.convertToArray(shape));
        ing.forEach((arg_0, arg_1) -> ((ShapedRecipe)recipe).setIngredient(arg_0, arg_1));
        group.ifPresent(arg_0 -> ((ShapedRecipe)recipe).setGroup(arg_0));
        category.ifPresent(arg_0 -> ((ShapedRecipe)recipe).setCategory(arg_0));
        return recipe;
    });
    public static final Codec<ShapelessRecipe> SHAPELESS_RECIPE = RecordCodecBuilder.create(NAMESPACED_KEY.fieldOf("id", CraftingRecipe::getKey), RECIPE_CHOICE.list().fieldOf("ingredients", ShapelessRecipe::getChoiceList), ITEM_STACK.fieldOf("result", CraftingRecipe::getResult), STRING.optional().fieldOf("group", s -> Optional.of(s.getGroup())), Codec.enumCodec(CraftingBookCategory.class).optional().fieldOf("category", s -> Optional.of(s.getCategory())), (id, choices, result, group, cat) -> {
        ShapelessRecipe recipe = new ShapelessRecipe(id, result);
        choices.forEach(arg_0 -> ((ShapelessRecipe)recipe).addIngredient(arg_0));
        group.ifPresent(arg_0 -> ((ShapelessRecipe)recipe).setGroup(arg_0));
        cat.ifPresent(arg_0 -> ((ShapelessRecipe)recipe).setCategory(arg_0));
        return recipe;
    });
    public static final Codec<TransmuteRecipe> TRANSMUTE_RECIPE = RecordCodecBuilder.create(NAMESPACED_KEY.fieldOf("id", CraftingRecipe::getKey), RECIPE_CHOICE.fieldOf("input", TransmuteRecipe::getInput), RECIPE_CHOICE.fieldOf("material", TransmuteRecipe::getMaterial), ITEM_STACK.fieldOf("result", CraftingRecipe::getResult), STRING.optional().fieldOf("group", s -> Optional.of(s.getGroup())), Codec.enumCodec(CraftingBookCategory.class).optional().fieldOf("category", s -> Optional.of(s.getCategory())), (id, input, material, result, group, cat) -> {
        TransmuteRecipe recipe = new TransmuteRecipe(id, result.getType(), input, material);
        group.ifPresent(arg_0 -> ((TransmuteRecipe)recipe).setGroup(arg_0));
        cat.ifPresent(arg_0 -> ((TransmuteRecipe)recipe).setCategory(arg_0));
        return recipe;
    });
    public static final Codec<FurnaceRecipe> FURNACE_RECIPE = RecordCodecBuilder.create(NAMESPACED_KEY.fieldOf("id", CookingRecipe::getKey), RECIPE_CHOICE.fieldOf("input", CookingRecipe::getInputChoice), ITEM_STACK.fieldOf("result", CookingRecipe::getResult), INT.fieldOf("cooking_time", CookingRecipe::getCookingTime), FLOAT.fieldOf("exp", CookingRecipe::getExperience), STRING.optional().fieldOf("group", f -> Optional.of(f.getGroup())), Codec.enumCodec(CookingBookCategory.class).optional().fieldOf("category", f -> Optional.of(f.getCategory())), (id, input, result, time, exp, group, cat) -> {
        FurnaceRecipe recipe = new FurnaceRecipe(id, result, input, exp.floatValue(), time.intValue());
        cat.ifPresent(arg_0 -> ((FurnaceRecipe)recipe).setCategory(arg_0));
        return recipe;
    });
    public static final Codec<SmokingRecipe> SMOKING_RECIPE = RecordCodecBuilder.create(NAMESPACED_KEY.fieldOf("id", CookingRecipe::getKey), RECIPE_CHOICE.fieldOf("input", CookingRecipe::getInputChoice), ITEM_STACK.fieldOf("result", CookingRecipe::getResult), INT.fieldOf("cooking_time", CookingRecipe::getCookingTime), FLOAT.fieldOf("exp", CookingRecipe::getExperience), STRING.optional().fieldOf("group", f -> Optional.of(f.getGroup())), Codec.enumCodec(CookingBookCategory.class).optional().fieldOf("category", f -> Optional.of(f.getCategory())), (id, input, result, time, exp, group, cat) -> {
        SmokingRecipe recipe = new SmokingRecipe(id, result, input, exp.floatValue(), time.intValue());
        cat.ifPresent(arg_0 -> ((SmokingRecipe)recipe).setCategory(arg_0));
        return recipe;
    });
    public static final Codec<BlastingRecipe> BLASTING_RECIPE = RecordCodecBuilder.create(NAMESPACED_KEY.fieldOf("id", CookingRecipe::getKey), RECIPE_CHOICE.fieldOf("input", CookingRecipe::getInputChoice), ITEM_STACK.fieldOf("result", CookingRecipe::getResult), INT.fieldOf("cooking_time", CookingRecipe::getCookingTime), FLOAT.fieldOf("exp", CookingRecipe::getExperience), STRING.optional().fieldOf("group", f -> Optional.of(f.getGroup())), Codec.enumCodec(CookingBookCategory.class).optional().fieldOf("category", f -> Optional.of(f.getCategory())), (id, input, result, time, exp, group, cat) -> {
        BlastingRecipe recipe = new BlastingRecipe(id, result, input, exp.floatValue(), time.intValue());
        cat.ifPresent(arg_0 -> ((BlastingRecipe)recipe).setCategory(arg_0));
        return recipe;
    });
    public static final Codec<CampfireRecipe> CAMPFIRE_RECIPE = RecordCodecBuilder.create(NAMESPACED_KEY.fieldOf("id", CookingRecipe::getKey), RECIPE_CHOICE.fieldOf("input", CookingRecipe::getInputChoice), ITEM_STACK.fieldOf("result", CookingRecipe::getResult), INT.fieldOf("cooking_time", CookingRecipe::getCookingTime), FLOAT.fieldOf("exp", CookingRecipe::getExperience), STRING.optional().fieldOf("group", f -> Optional.of(f.getGroup())), Codec.enumCodec(CookingBookCategory.class).optional().fieldOf("category", f -> Optional.of(f.getCategory())), (id, input, result, time, exp, group, cat) -> {
        CampfireRecipe recipe = new CampfireRecipe(id, result, input, exp.floatValue(), time.intValue());
        cat.ifPresent(arg_0 -> ((CampfireRecipe)recipe).setCategory(arg_0));
        return recipe;
    });
    public static final Codec<StonecuttingRecipe> STONECUTTING_RECIPE = RecordCodecBuilder.create(NAMESPACED_KEY.fieldOf("id", StonecuttingRecipe::getKey), RECIPE_CHOICE.fieldOf("input", StonecuttingRecipe::getInputChoice), ITEM_STACK.fieldOf("result", StonecuttingRecipe::getResult), STRING.optional().fieldOf("group", f -> Optional.of(f.getGroup())), (id, input, result, group) -> {
        StonecuttingRecipe recipe = new StonecuttingRecipe(id, result, input);
        group.ifPresent(arg_0 -> ((StonecuttingRecipe)recipe).setGroup(arg_0));
        return recipe;
    });
    public static final Codec<SmithingTransformRecipe> SMITHING_TRANSFORM_RECIPE = RecordCodecBuilder.create(NAMESPACED_KEY.fieldOf("id", SmithingRecipe::getKey), RECIPE_CHOICE.fieldOf("base", SmithingRecipe::getBase), RECIPE_CHOICE.fieldOf("template", SmithingTransformRecipe::getTemplate), RECIPE_CHOICE.fieldOf("addition", SmithingRecipe::getAddition), ITEM_STACK.fieldOf("result", SmithingRecipe::getResult), BOOLEAN.optional().fieldOf("copy_components", r -> Optional.of(r.willCopyDataComponents())), (id, base, template, addition, result, copy) -> copy.map(aBoolean -> new SmithingTransformRecipe(id, result, template, base, addition, aBoolean.booleanValue())).orElseGet(() -> new SmithingTransformRecipe(id, result, template, base, addition)));
    public static final Codec<PotionMix> POTION_MIX = RecordCodecBuilder.create(NAMESPACED_KEY.fieldOf("id", PotionMix::getKey), RECIPE_CHOICE.fieldOf("input", PotionMix::getInput), RECIPE_CHOICE.fieldOf("ingredient", PotionMix::getIngredient), ITEM_STACK.fieldOf("result", PotionMix::getResult), (id, input, ingredient, result) -> new PotionMix(id, result, input, ingredient));
}

