/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.serialization.ops;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.darksoulq.abyssallib.common.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JsonOps
extends DynamicOps<JsonNode> {
    public static final JsonOps INSTANCE = new JsonOps();

    private JsonOps() {
    }

    @Override
    public JsonNode createString(String value) {
        return TextNode.valueOf((String)value);
    }

    @Override
    public JsonNode createInt(int value) {
        return IntNode.valueOf((int)value);
    }

    @Override
    public JsonNode createLong(long value) {
        return LongNode.valueOf((long)value);
    }

    @Override
    public JsonNode createFloat(float value) {
        return FloatNode.valueOf((float)value);
    }

    @Override
    public JsonNode createDouble(double value) {
        return DoubleNode.valueOf((double)value);
    }

    @Override
    public JsonNode createBoolean(boolean value) {
        return BooleanNode.valueOf((boolean)value);
    }

    @Override
    public JsonNode createList(List<JsonNode> elements) {
        ArrayNode array = JsonNodeFactory.instance.arrayNode();
        for (JsonNode elem : elements) {
            array.add(elem);
        }
        return array;
    }

    @Override
    public JsonNode createMap(Map<JsonNode, JsonNode> map) {
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<JsonNode, JsonNode> entry : map.entrySet()) {
            obj.set(entry.getKey().asText(), entry.getValue());
        }
        return obj;
    }

    @Override
    public Optional<String> getStringValue(JsonNode input) {
        return input.isTextual() ? Optional.of(input.asText()) : Optional.empty();
    }

    @Override
    public Optional<Integer> getIntValue(JsonNode input) {
        return input.isNumber() ? Optional.of(input.asInt()) : Optional.empty();
    }

    @Override
    public Optional<Long> getLongValue(JsonNode input) {
        return input.isNumber() ? Optional.of(input.asLong()) : Optional.empty();
    }

    @Override
    public Optional<Float> getFloatValue(JsonNode input) {
        return input.isNumber() ? Optional.of(Float.valueOf(input.floatValue())) : Optional.empty();
    }

    @Override
    public Optional<Double> getDoubleValue(JsonNode input) {
        return input.isNumber() ? Optional.of(input.doubleValue()) : Optional.empty();
    }

    @Override
    public Optional<Boolean> getBooleanValue(JsonNode input) {
        return input.isBoolean() ? Optional.of(input.asBoolean()) : Optional.empty();
    }

    @Override
    public Optional<List<JsonNode>> getList(JsonNode input) {
        if (!input.isArray()) {
            return Optional.empty();
        }
        ArrayList list = new ArrayList();
        input.forEach(list::add);
        return Optional.of(list);
    }

    @Override
    public Optional<Map<JsonNode, JsonNode>> getMap(JsonNode input) {
        if (!input.isObject()) {
            return Optional.empty();
        }
        LinkedHashMap map = new LinkedHashMap();
        input.fields().forEachRemaining(entry -> map.put(TextNode.valueOf((String)((String)entry.getKey())), (JsonNode)entry.getValue()));
        return Optional.of(map);
    }

    @Override
    public JsonNode empty() {
        return NullNode.instance;
    }
}

