/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.serialization.ops;

import com.github.darksoulq.abyssallib.common.serialization.DynamicOps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.yaml.snakeyaml.Yaml;

public class YamlOps
extends DynamicOps<Object> {
    public static final YamlOps INSTANCE = new YamlOps();
    private static final Yaml yaml = new Yaml();

    private YamlOps() {
    }

    @Override
    public Object createString(String value) {
        return value;
    }

    @Override
    public Object createInt(int value) {
        return value;
    }

    @Override
    public Object createLong(long value) {
        return value;
    }

    @Override
    public Object createFloat(float value) {
        return Float.valueOf(value);
    }

    @Override
    public Object createDouble(double value) {
        return value;
    }

    @Override
    public Object createBoolean(boolean value) {
        return value;
    }

    @Override
    public Object createList(List<Object> elements) {
        return new ArrayList<Object>(elements);
    }

    @Override
    public Object createMap(Map<Object, Object> map) {
        return new LinkedHashMap<Object, Object>(map);
    }

    @Override
    public Optional<String> getStringValue(Object input) {
        Optional<String> optional;
        if (input instanceof String) {
            String s = (String)input;
            optional = Optional.of(s);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Optional<Integer> getIntValue(Object input) {
        Optional<Integer> optional;
        if (input instanceof Integer) {
            Integer i = (Integer)input;
            optional = Optional.of(i);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Optional<Long> getLongValue(Object input) {
        Optional<Long> optional;
        if (input instanceof Long) {
            Long l = (Long)input;
            optional = Optional.of(l);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Optional<Float> getFloatValue(Object input) {
        Optional<Float> optional;
        if (input instanceof Float) {
            Float f = (Float)input;
            optional = Optional.of(f);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Optional<Double> getDoubleValue(Object input) {
        Optional<Double> optional;
        if (input instanceof Double) {
            Double d = (Double)input;
            optional = Optional.of(d);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Optional<Boolean> getBooleanValue(Object input) {
        Optional<Boolean> optional;
        if (input instanceof Boolean) {
            Boolean b = (Boolean)input;
            optional = Optional.of(b);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Optional<List<Object>> getList(Object input) {
        return input instanceof List ? Optional.of((List)input) : Optional.empty();
    }

    @Override
    public Optional<Map<Object, Object>> getMap(Object input) {
        return input instanceof Map ? Optional.of((Map)input) : Optional.empty();
    }

    @Override
    public Object empty() {
        return null;
    }

    public Object parse(String yamlText) {
        return this.normalize(yaml.load(yamlText));
    }

    public Object parse(InputStream in) {
        return this.normalize(yaml.load(in));
    }

    public static String dump(Object obj) {
        return yaml.dump(obj);
    }

    private Object normalize(Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            LinkedHashMap<String, Object> normalized = new LinkedHashMap<String, Object>();
            for (Map.Entry e : map.entrySet()) {
                normalized.put(String.valueOf(e.getKey()), this.normalize(e.getValue()));
            }
            return normalized;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            ArrayList<Object> normalized = new ArrayList<Object>();
            for (Object o : list) {
                normalized.add(this.normalize(o));
            }
            return normalized;
        }
        return obj;
    }
}

