/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.util;

import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.component.CustomData;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class CTag {
    private final CompoundTag baseTag;

    public CTag() {
        this.baseTag = new CompoundTag();
    }

    public CTag(CompoundTag base) {
        this.baseTag = base;
    }

    public void set(String key, String value) {
        this.baseTag.putString(key, value);
    }

    public void set(String key, int value) {
        this.baseTag.putInt(key, value);
    }

    public void set(String key, int[] value) {
        this.baseTag.putIntArray(key, value);
    }

    public void set(String key, boolean value) {
        this.baseTag.putBoolean(key, value);
    }

    public void set(String key, float value) {
        this.baseTag.putFloat(key, value);
    }

    public void set(String key, byte value) {
        this.baseTag.putByte(key, value);
    }

    public void set(String key, byte[] value) {
        this.baseTag.putByteArray(key, value);
    }

    public boolean has(String key) {
        return this.baseTag.contains(key);
    }

    public Optional<String> getString(String key) {
        return this.baseTag.getString(key);
    }

    public Optional<Integer> getInt(String key) {
        return this.baseTag.getInt(key);
    }

    public Optional<int[]> getIntArray(String key) {
        return this.baseTag.getIntArray(key);
    }

    public Optional<Boolean> getBoolean(String key) {
        return this.baseTag.getBoolean(key);
    }

    public Optional<Float> getFloat(String key) {
        return this.baseTag.getFloat(key);
    }

    public Optional<Byte> getByte(String key) {
        return this.baseTag.getByte(key);
    }

    public Optional<byte[]> getByteArray(String key) {
        return this.baseTag.getByteArray(key);
    }

    public void clear() {
        for (String key : this.baseTag.keySet()) {
            this.baseTag.remove(key);
        }
    }

    public CompoundTag toVanilla() {
        return this.baseTag;
    }

    public static CTag getCTag(ItemStack stack) {
        CompoundTag tag;
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy((ItemStack)stack);
        CustomData dta = (CustomData)nms.get(DataComponents.CUSTOM_DATA);
        if (dta == null) {
            dta = CustomData.EMPTY;
        }
        if ((tag = dta.copyTag()).getCompound("CustomData").isPresent()) {
            CompoundTag custom = (CompoundTag)tag.getCompound("CustomData").get();
            return new CTag(custom);
        }
        tag.put("CustomData", (Tag)new CompoundTag());
        return new CTag((CompoundTag)tag.getCompound("CustomData").get());
    }

    public static void setCTag(CTag container, ItemStack stack) {
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy((ItemStack)stack);
        CustomData data = (CustomData)nms.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            data = CustomData.EMPTY;
        }
        CompoundTag tag = data.copyTag();
        tag.put("CustomData", (Tag)container.toVanilla());
        data = CustomData.of((CompoundTag)tag);
        nms.set(DataComponents.CUSTOM_DATA, (Object)data);
        ItemStack updated = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nms);
        stack.setItemMeta(updated.getItemMeta());
    }
}

