/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class Either<L, R> {
    private Either() {
    }

    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public abstract Optional<L> left();

    public abstract Optional<R> right();

    public abstract L leftOrElse(L var1);

    public abstract R rightOrElse(R var1);

    public abstract L leftOrThrow();

    public abstract R rightOrThrow();

    public abstract <LL> Either<LL, R> mapLeft(Function<? super L, ? extends LL> var1);

    public abstract <RR> Either<L, RR> mapRight(Function<? super R, ? extends RR> var1);

    public <LL, RR> Either<LL, RR> map(Function<? super L, ? extends LL> lf, Function<? super R, ? extends RR> rf) {
        return this.mapLeft(lf).mapRight(rf);
    }

    public abstract void ifLeft(Consumer<? super L> var1);

    public abstract void ifRight(Consumer<? super R> var1);

    public void apply(Consumer<? super L> lc, Consumer<? super R> rc) {
        this.ifLeft(lc);
        this.ifRight(rc);
    }

    public abstract <T> T fold(Function<? super L, ? extends T> var1, Function<? super R, ? extends T> var2);

    public <LL, RR> Either<LL, RR> flatMap(Function<? super L, ? extends Either<? extends LL, ? extends RR>> lf, Function<? super R, ? extends Either<? extends LL, ? extends RR>> rf) {
        return this.fold(lf, rf);
    }

    public Either<R, L> swap() {
        return this.fold(Either::right, Either::left);
    }

    public static final class Left<L, R>
    extends Either<L, R> {
        private final L value;

        public Left(L value) {
            this.value = Objects.requireNonNull(value);
        }

        public L value() {
            return this.value;
        }

        @Override
        public Optional<L> left() {
            return Optional.of(this.value);
        }

        @Override
        public Optional<R> right() {
            return Optional.empty();
        }

        @Override
        public L leftOrElse(L def) {
            return this.value;
        }

        @Override
        public R rightOrElse(R def) {
            return def;
        }

        @Override
        public L leftOrThrow() {
            return this.value;
        }

        @Override
        public R rightOrThrow() {
            throw new IllegalStateException("Right value requested from Left");
        }

        @Override
        public <LL> Either<LL, R> mapLeft(Function<? super L, ? extends LL> f) {
            return new Left<LL, R>(f.apply(this.value));
        }

        @Override
        public <RR> Either<L, RR> mapRight(Function<? super R, ? extends RR> f) {
            return new Left<L, R>(this.value);
        }

        @Override
        public void ifLeft(Consumer<? super L> c) {
            c.accept(this.value);
        }

        @Override
        public void ifRight(Consumer<? super R> c) {
        }

        @Override
        public <T> T fold(Function<? super L, ? extends T> lf, Function<? super R, ? extends T> rf) {
            return lf.apply(this.value);
        }

        public String toString() {
            return "Left(" + String.valueOf(this.value) + ")";
        }
    }

    public static final class Right<L, R>
    extends Either<L, R> {
        private final R value;

        public Right(R value) {
            this.value = Objects.requireNonNull(value);
        }

        public R value() {
            return this.value;
        }

        @Override
        public Optional<L> left() {
            return Optional.empty();
        }

        @Override
        public Optional<R> right() {
            return Optional.of(this.value);
        }

        @Override
        public L leftOrElse(L def) {
            return def;
        }

        @Override
        public R rightOrElse(R def) {
            return this.value;
        }

        @Override
        public L leftOrThrow() {
            throw new IllegalStateException("Left value requested from Right");
        }

        @Override
        public R rightOrThrow() {
            return this.value;
        }

        @Override
        public <LL> Either<LL, R> mapLeft(Function<? super L, ? extends LL> f) {
            return new Right<L, R>(this.value);
        }

        @Override
        public <RR> Either<L, RR> mapRight(Function<? super R, ? extends RR> f) {
            return new Right<L, RR>(f.apply(this.value));
        }

        @Override
        public void ifLeft(Consumer<? super L> c) {
        }

        @Override
        public void ifRight(Consumer<? super R> c) {
            c.accept(this.value);
        }

        @Override
        public <T> T fold(Function<? super L, ? extends T> lf, Function<? super R, ? extends T> rf) {
            return rf.apply(this.value);
        }

        public String toString() {
            return "Right(" + String.valueOf(this.value) + ")";
        }
    }
}

