/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.util;

import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minecraft.resources.ResourceLocation;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

public class Identifier {
    private final String key;
    private final String namespace;
    private final String path;

    private Identifier(String key, String namespace, String path) {
        this.key = key;
        this.namespace = namespace;
        this.path = path;
    }

    @NotNull
    public static Identifier of(@NotNull String value) {
        String[] parts = value.split(":", 3);
        if (Identifier.isValid2Part(value)) {
            return new Identifier(null, parts[0], parts[1]);
        }
        if (Identifier.isValid3Part(value)) {
            return new Identifier(parts[0], parts[1], parts[2]);
        }
        throw new IllegalArgumentException("Identifier must be in format 'namespace:path' or 'key:namespace:path'");
    }

    @NotNull
    public static Identifier of(@NotNull String namespace, @NotNull String path) {
        if (!Identifier.isValid(namespace) || !Identifier.isValid(path)) {
            throw new IllegalArgumentException("Invalid namespace or path: " + namespace + ":" + path);
        }
        return new Identifier(null, namespace, path);
    }

    @NotNull
    public static Identifier of(@NotNull String key, @NotNull String namespace, @NotNull String path) {
        if (!(Identifier.isValid(key) && Identifier.isValid(namespace) && Identifier.isValid(path))) {
            throw new IllegalArgumentException("Invalid key/namespace/path: " + key + ":" + namespace + ":" + path);
        }
        return new Identifier(key, namespace, path);
    }

    public String getKey() {
        return this.key;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPath() {
        return this.path;
    }

    @NotNull
    public String toString() {
        return this.key != null ? this.key + ":" + this.namespace + ":" + this.path : this.namespace + ":" + this.path;
    }

    @NotNull
    public NamespacedKey asNamespacedKey() {
        return new NamespacedKey(this.namespace, this.path);
    }

    @NotNull
    public Key asKey() {
        return Key.key((String)this.namespace, (String)this.path);
    }

    @NotNull
    public ResourceLocation asResourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)this.path);
    }

    public static boolean isValid(String input) {
        return input != null && input.matches("[a-z0-9._-]+");
    }

    public static boolean isValid2Part(String input) {
        if (input == null) {
            return false;
        }
        String[] parts = input.split(":", 2);
        return parts.length == 2 && Identifier.isValid(parts[0]) && Identifier.isValid(parts[1]);
    }

    public static boolean isValid3Part(String input) {
        if (input == null) {
            return false;
        }
        String[] parts = input.split(":", 3);
        return parts.length == 3 && Identifier.isValid(parts[0]) && Identifier.isValid(parts[1]) && Identifier.isValid(parts[2]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Identifier)) {
            return false;
        }
        Identifier other = (Identifier)o;
        return Objects.equals(this.key, other.key) && this.namespace.equals(other.namespace) && this.path.equals(other.path);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.namespace, this.path);
    }
}

