/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.bridge.item;

import com.github.darksoulq.abyssallib.common.serialization.Codec;
import com.github.darksoulq.abyssallib.common.serialization.ExtraCodecs;
import com.github.darksoulq.abyssallib.common.serialization.ops.YamlOps;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.bridge.Provider;
import com.github.darksoulq.abyssallib.world.item.Item;
import com.github.darksoulq.abyssallib.world.item.component.Vanilla;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MinecraftProvider
extends Provider<ItemStack> {
    public MinecraftProvider() {
        super("minecraft");
    }

    @Override
    public boolean belongs(ItemStack value) {
        if (value == null) {
            return false;
        }
        return value.equals((Object)ItemStack.of((Material)value.getType()));
    }

    @Override
    public Identifier getId(ItemStack value) {
        return Identifier.of("minecraft", value.getType().name().toLowerCase(Locale.ROOT));
    }

    @Override
    public ItemStack get(Identifier id) {
        return ItemStack.of((Material)Material.valueOf((String)id.getPath().toUpperCase(Locale.ROOT)));
    }

    @Override
    public Map<String, Optional<Object>> serializeData(ItemStack value) {
        HashMap<String, Optional<Object>> map = new HashMap<String, Optional<Object>>();
        Item item = new Item(value);
        item.getComponentMap().getAllComponents().forEach(d -> {
            String id = d.getId().toString();
            Codec<?> codec = ExtraCodecs.DATA_COMPONENT_CODECS.get(id);
            if (codec == null) {
                return;
            }
            try {
                Object encoded = codec.encode(YamlOps.INSTANCE, d);
                String str = encoded == null ? "" : encoded.toString();
                map.put(id, str.isEmpty() ? Optional.empty() : Optional.of(str));
            }
            catch (Codec.CodecException e) {
                e.printStackTrace();
            }
        });
        return map;
    }

    @Override
    public void deserializeData(Map<String, Optional<Object>> data, ItemStack value) {
        for (Map.Entry<String, Optional<Object>> entry : data.entrySet()) {
            Codec<?> codec;
            Optional<Object> optional = entry.getValue();
            if (optional.isEmpty() || (codec = ExtraCodecs.DATA_COMPONENT_CODECS.get(entry.getKey())) == null) continue;
            try {
                Object decoded = codec.decode(YamlOps.INSTANCE, optional.get());
                if (!(decoded instanceof Vanilla)) continue;
                Vanilla v = (Vanilla)decoded;
                v.apply(value);
            }
            catch (Codec.CodecException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

