/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.command;

import com.github.darksoulq.abyssallib.server.command.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CommandBus {
    private static CommandDispatcher<CommandSourceStack> dispatcher;
    private static final List<RegisteredCommand> registered;

    public static void init(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandBus.dispatcher = dispatcher;
    }

    public static void register(String pluginId, Object handler) {
        for (Method method : handler.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Command.class)) continue;
            Command command = method.getAnnotation(Command.class);
            String commandName = command.name();
            LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)commandName);
            ArrayList<LiteralArgumentBuilder> aliases = new ArrayList<LiteralArgumentBuilder>();
            for (String alias : command.aliases()) {
                aliases.add(LiteralArgumentBuilder.literal((String)alias));
            }
            if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == LiteralArgumentBuilder.class) {
                try {
                    method.invoke(handler, root);
                    for (LiteralArgumentBuilder alias : aliases) {
                        method.invoke(handler, alias);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                throw new IllegalArgumentException("Method " + String.valueOf(method) + " must have exactly one parameter of type LiteralArgumentBuilder.");
            }
            registered.add(new RegisteredCommand(pluginId, method, handler));
            CommandBus.getDispatcher().register(root);
            for (LiteralArgumentBuilder alias : aliases) {
                CommandBus.getDispatcher().register(alias);
            }
        }
    }

    public static void reloadAll() {
        CommandBus.unregisterAll();
        for (RegisteredCommand cmd : registered) {
            LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)cmd.method.getAnnotation(Command.class).name());
            ArrayList<LiteralArgumentBuilder> aliases = new ArrayList<LiteralArgumentBuilder>();
            for (String alias : cmd.method.getAnnotation(Command.class).aliases()) {
                aliases.add(LiteralArgumentBuilder.literal((String)alias));
            }
            if (cmd.method.getParameterCount() == 1 && cmd.method.getParameterTypes()[0] == LiteralArgumentBuilder.class) {
                try {
                    cmd.method.invoke(cmd.handler, root);
                    for (LiteralArgumentBuilder alias : aliases) {
                        cmd.method.invoke(cmd.handler, alias);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                throw new IllegalArgumentException("Method " + String.valueOf(cmd.method) + " must have exactly one parameter of type LiteralArgumentBuilder.");
            }
            CommandBus.getDispatcher().register(root);
            for (LiteralArgumentBuilder alias : aliases) {
                CommandBus.getDispatcher().register(alias);
            }
        }
    }

    private static void unregisterAll() {
        CommandDispatcher<CommandSourceStack> dispatcher = CommandBus.getDispatcher();
        Collection commandMap = dispatcher.getRoot().getChildren();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (CommandNode child : commandMap) {
            String name = child.getName();
            boolean ours = registered.stream().anyMatch(r -> r.method.getAnnotation(Command.class).name().equals(name) || Arrays.asList(r.method.getAnnotation(Command.class).aliases()).contains(name));
            if (!ours) continue;
            toRemove.add(name);
        }
        for (String name : toRemove) {
            dispatcher.getRoot().removeCommand(name);
        }
    }

    public static CommandDispatcher<CommandSourceStack> getDispatcher() {
        return dispatcher;
    }

    static {
        registered = new ArrayList<RegisteredCommand>();
    }

    private record RegisteredCommand(String pluginId, Method method, Object handler) {
    }
}

