/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PostEffect
implements Asset {
    @NotNull
    private final String namespace;
    @NotNull
    private final String id;
    private byte[] rawData;
    private final List<String> targets = new ArrayList<String>();
    private final List<Pass> passes = new ArrayList<Pass>();

    public PostEffect(@NotNull String namespace, @NotNull String id) {
        this.namespace = namespace;
        this.id = id;
    }

    public PostEffect(@NotNull String namespace, @NotNull String id, byte[] data) {
        this.namespace = namespace;
        this.id = id;
        this.rawData = data;
    }

    public PostEffect(@NotNull Plugin plugin, @NotNull String namespace, @NotNull String id) {
        this.namespace = namespace;
        this.id = id;
        String resource = "resourcepack/" + namespace + "/post_effect/" + id + ".json";
        try (InputStream in = plugin.getResource(resource);){
            if (in == null) {
                throw new IllegalStateException("PostEffect JSON not found: " + resource);
            }
            this.rawData = in.readAllBytes();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load PostEffect JSON", e);
        }
    }

    public PostEffect addTarget(@NotNull String target) {
        this.targets.add(target);
        return this;
    }

    public PostEffect addPass(@NotNull String name, @NotNull String inTarget, @NotNull String outTarget, @NotNull List<Uniform> uniforms) {
        this.passes.add(new Pass(name, inTarget, outTarget, uniforms));
        return this;
    }

    @Override
    public void emit(@NotNull Map<String, byte[]> files) {
        if (this.rawData != null) {
            files.put(this.path(), this.rawData);
            return;
        }
        JsonObject root = new JsonObject();
        if (!this.targets.isEmpty()) {
            JsonArray tgt = new JsonArray();
            this.targets.forEach(t -> tgt.add(t));
            root.add("targets", (JsonElement)tgt);
        }
        JsonArray passArr = new JsonArray();
        for (Pass p : this.passes) {
            JsonObject o = new JsonObject();
            o.addProperty("name", p.name);
            o.addProperty("intarget", p.inTarget);
            o.addProperty("outtarget", p.outTarget);
            if (!p.uniforms.isEmpty()) {
                JsonArray uarr = new JsonArray();
                for (Uniform u : p.uniforms) {
                    JsonObject uo = new JsonObject();
                    uo.addProperty("name", u.name);
                    JsonArray vals = new JsonArray();
                    for (Number number : u.values) {
                        vals.add((Number)number.doubleValue());
                    }
                    uo.add("values", (JsonElement)vals);
                    if (u.type != null) {
                        uo.addProperty("type", u.type);
                    }
                    if (u.count != null) {
                        uo.addProperty("count", (Number)u.count);
                    }
                    uarr.add((JsonElement)uo);
                }
                o.add("uniforms", (JsonElement)uarr);
            }
            if (!p.samplers.isEmpty()) {
                JsonArray sarr = new JsonArray();
                p.samplers.forEach(arg_0 -> ((JsonArray)sarr).add(arg_0));
                o.add("samplers", (JsonElement)sarr);
            }
            root.add("passes", (JsonElement)passArr);
            passArr.add((JsonElement)o);
        }
        files.put(this.path(), TextUtil.GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
    }

    private String path() {
        return "assets/" + this.namespace + "/post_effect/" + this.id + ".json";
    }

    private static class Pass {
        final String name;
        final String inTarget;
        final String outTarget;
        final List<Uniform> uniforms;
        final List<String> samplers = new ArrayList<String>();

        Pass(String name, String in, String out, List<Uniform> u) {
            this.name = name;
            this.inTarget = in;
            this.outTarget = out;
            this.uniforms = u != null ? u : Collections.emptyList();
        }

        Pass samplers(String ... s) {
            this.samplers.addAll(Arrays.asList(s));
            return this;
        }
    }

    public static class Uniform {
        public final String name;
        public final List<Double> values;
        public final String type;
        public final Integer count;

        public Uniform(@NotNull String name, @NotNull double[] values) {
            this.name = name;
            this.values = new ArrayList<Double>();
            for (double d : values) {
                this.values.add(d);
            }
            this.type = null;
            this.count = null;
        }

        public Uniform(@NotNull String name, @NotNull double[] values, @NotNull String type, Integer count) {
            this.name = name;
            this.values = new ArrayList<Double>();
            for (double d : values) {
                this.values.add(d);
            }
            this.type = type;
            this.count = count;
        }
    }
}

