/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class Sounds
implements Asset {
    private final Plugin plugin;
    private final String namespace;
    private final Map<String, Sound> sounds = new LinkedHashMap<String, Sound>();

    public Sounds(@NotNull Plugin plugin, @NotNull String namespace) {
        this.plugin = plugin;
        this.namespace = namespace;
    }

    @NotNull
    public Sound sound(@NotNull String name) {
        Sound sound;
        block9: {
            InputStream in = this.plugin.getResource("resourcepack/" + this.namespace + "/sounds/" + name + ".ogg");
            try {
                if (in == null) {
                    throw new FileNotFoundException(name);
                }
                byte[] data = in.readAllBytes();
                sound = this.sound(name, data);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to autoload sound: " + name, e);
                }
            }
            in.close();
        }
        return sound;
    }

    @NotNull
    public Sound sound(@NotNull String name, byte @NotNull [] data) {
        Sound sound = new Sound(this.namespace, name, SoundCategory.MASTER, data);
        this.sounds.put(name, sound);
        return sound;
    }

    @Override
    public void emit(@NotNull Map<String, byte[]> output) {
        JsonObject root = new JsonObject();
        for (Sound sound : this.sounds.values()) {
            sound.emit(output, root);
        }
        output.put("assets/" + this.namespace + "/sounds.json", new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
    }

    @ApiStatus.Experimental
    public static class Sound {
        private final String namespace;
        private final String name;
        private final SoundCategory category;
        private final byte[] data;

        public Sound(@NotNull String namespace, @NotNull String name, @NotNull SoundCategory category, byte @NotNull [] data) {
            this.namespace = namespace;
            this.name = name;
            this.category = category;
            this.data = data;
        }

        public void emit(@NotNull Map<String, byte[]> files, @NotNull JsonObject soundsJson) {
            String key = this.namespace + "." + this.name;
            String assetPath = "assets/" + this.namespace + "/sounds/" + this.name + ".ogg";
            files.put(assetPath, this.data);
            JsonObject entry = new JsonObject();
            entry.addProperty("category", this.category.toString());
            JsonArray arr = new JsonArray();
            JsonObject fileObj = new JsonObject();
            fileObj.addProperty("name", this.namespace + ":sounds/" + this.name);
            fileObj.addProperty("stream", Boolean.valueOf(false));
            arr.add((JsonElement)fileObj);
            entry.add("sounds", (JsonElement)arr);
            soundsJson.add(key, (JsonElement)entry);
        }

        public void play(@NotNull Player player) {
            player.playSound(player.getLocation(), this.namespace + ":" + this.name, this.category.toBukkit(), 1.0f, 1.0f);
        }

        public void play(@NotNull Player player, float volume, float pitch) {
            player.playSound(player.getLocation(), this.namespace + ":" + this.name, this.category.toBukkit(), volume, pitch);
        }

        public void play(@NotNull Location location) {
            location.getWorld().playSound(location, this.namespace + ":" + this.name, this.category.toBukkit(), 1.0f, 1.0f);
        }

        public void play(@NotNull Location location, float volume, float pitch) {
            location.getWorld().playSound(location, this.namespace + ":" + this.name, this.category.toBukkit(), volume, pitch);
        }

        @NotNull
        public String id() {
            return this.namespace + ":" + this.name;
        }
    }

    public static enum SoundCategory {
        MASTER,
        MUSIC,
        RECORDS,
        WEATHER,
        BLOCK,
        HOSTILE,
        NEUTRAL,
        PLAYER,
        AMBIENT,
        VOICE;


        public org.bukkit.SoundCategory toBukkit() {
            return org.bukkit.SoundCategory.valueOf((String)this.name());
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

