/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.github.darksoulq.abyssallib.server.resource.asset.Texture;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class WaypointStyle
implements Asset {
    private final String namespace;
    private final String id;
    private final byte[] rawData;
    private float nearDistance;
    private float farDistance;
    private final List<String> sprites = new ArrayList<String>();

    public WaypointStyle(@NotNull Plugin plugin, @NotNull String namespace, @NotNull String id) {
        this.namespace = namespace;
        this.id = id;
        try (InputStream in = plugin.getResource("resourcepack/" + namespace + "/waypoint_style/" + id + ".json");){
            if (in == null) {
                throw new RuntimeException("WaypointStyle not found: " + id);
            }
            this.rawData = in.readAllBytes();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load WaypointStyle: " + id, e);
        }
    }

    public WaypointStyle(String namespace, String id) {
        this.namespace = namespace;
        this.id = id;
        this.rawData = null;
    }

    public WaypointStyle(String namespace, String id, byte[] data) {
        this.namespace = namespace;
        this.id = id;
        this.rawData = data;
    }

    public WaypointStyle near(float d) {
        this.nearDistance = d;
        return this;
    }

    public WaypointStyle far(float d) {
        this.farDistance = d;
        return this;
    }

    public WaypointStyle sprite(Texture texture) {
        this.sprites.add(texture.file());
        return this;
    }

    @Override
    public void emit(Map<String, byte[]> files) {
        if (this.rawData != null) {
            files.put("assets/" + this.namespace + "/waypoint_style/" + this.id + ".json", this.rawData);
            return;
        }
        JsonObject root = new JsonObject();
        root.addProperty("near_distance", (Number)Float.valueOf(this.nearDistance));
        root.addProperty("far_distance", (Number)Float.valueOf(this.farDistance));
        JsonArray arr = new JsonArray();
        for (String s : this.sprites) {
            arr.add(s);
        }
        root.add("sprites", (JsonElement)arr);
        files.put("assets/" + this.namespace + "/waypoint_style/" + this.id + ".json", TextUtil.GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
    }
}

