/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.block;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.bridge.block.BridgeBlock;
import com.github.darksoulq.abyssallib.server.event.ActionResult;
import com.github.darksoulq.abyssallib.server.registry.Registries;
import com.github.darksoulq.abyssallib.world.block.BlockEntity;
import com.github.darksoulq.abyssallib.world.block.BlockProperties;
import com.github.darksoulq.abyssallib.world.block.internal.BlockManager;
import com.github.darksoulq.abyssallib.world.data.loot.LootTable;
import com.github.darksoulq.abyssallib.world.data.tag.Tag;
import com.github.darksoulq.abyssallib.world.data.tag.impl.BlockTag;
import com.github.darksoulq.abyssallib.world.item.Item;
import com.github.darksoulq.abyssallib.world.item.component.builtin.BlockItem;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public class CustomBlock
implements Cloneable {
    protected final Identifier id;
    private Material material = Material.DIRT;
    private Location location;
    private BlockEntity entity;
    public boolean allowPhysics = false;
    public BlockProperties properties = BlockProperties.of().build();

    public CustomBlock(Identifier id) {
        this.id = id;
    }

    public CustomBlock(Identifier id, Material material) {
        this.id = id;
        this.material = material;
    }

    public Identifier getId() {
        return this.id;
    }

    public Material getMaterial() {
        return this.material;
    }

    public boolean generateItem() {
        return true;
    }

    public Supplier<Item> getItem() {
        return () -> {
            Item item = new Item(this.id, this.material);
            item.setData(new BlockItem(this.id));
            return item;
        };
    }

    public BlockEntity createBlockEntity(Location loc) {
        return null;
    }

    @ApiStatus.Internal
    public void setEntity(BlockEntity entity) {
        this.entity = entity;
    }

    public Location getLocation() {
        return this.location;
    }

    protected void setLocation(Location location) {
        this.location = location;
    }

    public BlockEntity getEntity() {
        return this.entity;
    }

    public void place(Block bukkitBlock, boolean loading) {
        if (!this.material.isBlock()) {
            AbyssalLib.getInstance().getLogger().severe("Invalid block material for " + String.valueOf(this.id));
            return;
        }
        this.setLocation(bukkitBlock.getLocation());
        if (!loading) {
            bukkitBlock.setType(this.material);
            BlockEntity newEntity = this.createBlockEntity(this.getLocation());
            if (newEntity != null) {
                this.setEntity(newEntity);
            }
            BlockManager.register(this);
        } else {
            this.onLoad();
        }
    }

    public LootTable getLootTable() {
        return null;
    }

    public int getExpToDrop(Player player, int fortuneLevel, boolean silkTouch) {
        return 0;
    }

    public boolean hasTag(Identifier id) {
        Tag<?> tag = Registries.TAGS.get(id.toString());
        if (!(tag instanceof BlockTag)) {
            AbyssalLib.getInstance().getLogger().severe("Unknown tag: " + String.valueOf(id));
            return false;
        }
        BlockTag tag2 = (BlockTag)tag;
        return tag2.contains(new BridgeBlock<CustomBlock>(id, "abyssallib", this));
    }

    public static CustomBlock from(Block bukkitBlock) {
        if (bukkitBlock == null) {
            return null;
        }
        return BlockManager.get(bukkitBlock.getLocation());
    }

    public static Item asItem(CustomBlock block) {
        if (!block.generateItem()) {
            return null;
        }
        return Registries.ITEMS.get(block.getId().toString());
    }

    public boolean equals(Object o) {
        if (!(o instanceof CustomBlock)) {
            return false;
        }
        CustomBlock block = (CustomBlock)o;
        return Objects.equals(this.id, block.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public CustomBlock clone() {
        try {
            return (CustomBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void onLoad() {
    }

    public void onUnLoad() {
    }

    public ActionResult onPlaced(Player player, Location loc, ItemStack stack) {
        return ActionResult.PASS;
    }

    public ActionResult onBreak(Player player, Location loc, ItemStack tool) {
        return ActionResult.PASS;
    }

    public ActionResult onDestroyedByExplosion(@Nullable Entity eCause, @Nullable Block blockCause) {
        return ActionResult.PASS;
    }

    public void onLanded(Entity entity) {
    }

    public void onSteppedOn(LivingEntity entity) {
    }

    public int onRedstone(int oldCurrent, int newCurrent) {
        return oldCurrent;
    }

    public void onProjectileHit(Entity shooter) {
    }
}

