/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.entity.internal;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.database.Database;
import com.github.darksoulq.abyssallib.common.database.impl.sqlite.SqliteDatabase;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.event.custom.entity.EntitySpawnEvent;
import com.github.darksoulq.abyssallib.server.registry.Registries;
import com.github.darksoulq.abyssallib.world.entity.Entity;
import com.github.darksoulq.abyssallib.world.entity.SpawnCategory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiPredicate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class EntityManager {
    public static final Random rand = new Random();
    private static final Map<UUID, Entity<? extends LivingEntity>> ENTITIES = new HashMap<UUID, Entity<? extends LivingEntity>>();
    private static final Database database = new SqliteDatabase(new File(AbyssalLib.getInstance().getDataFolder(), "entities.db"));

    public static void load() {
        try {
            database.connect();
            database.executor().table("entities").create().ifNotExists().column("entity_uuid", "TEXT").column("entity_id", "TEXT").primaryKey("entity_uuid").execute();
            List<Entity> loaded = database.executor().table("entities").select(rs -> {
                UUID uuid = UUID.fromString(rs.getString("entity_uuid"));
                Identifier id = Identifier.of(rs.getString("entity_id"));
                Entity<? extends LivingEntity> entity = Registries.ENTITIES.get(id.toString());
                if (entity == null) {
                    return null;
                }
                entity = entity.clone();
                entity.uuid = uuid;
                return entity;
            });
            loaded.forEach(e -> {
                if (Bukkit.getEntity((UUID)e.uuid) == null) {
                    EntityManager.remove(e.uuid);
                    return;
                }
                ENTITIES.put(e.uuid, (Entity<? extends LivingEntity>)e);
            });
        }
        catch (Exception e2) {
            AbyssalLib.getInstance().getLogger().severe("Failed to load entity database: " + e2.getMessage());
            e2.printStackTrace();
        }
    }

    public static void add(Entity<? extends LivingEntity> entity) {
        ENTITIES.put(entity.uuid, entity);
        EntityManager.save(entity);
    }

    public static Entity<? extends LivingEntity> get(UUID uuid) {
        return ENTITIES.get(uuid);
    }

    public static void remove(UUID uuid) {
        ENTITIES.remove(uuid);
        try {
            database.executor().table("entities").delete().where("entity_uuid = ?", uuid.toString()).update();
        }
        catch (Exception e) {
            AbyssalLib.getInstance().getLogger().warning("Failed to remove entity: " + e.getMessage());
        }
    }

    public static void save(Entity<? extends LivingEntity> entity) {
        database.executor().table("entities").insert().value("entity_uuid", entity.uuid.toString()).value("entity_id", entity.getId().toString()).execute();
    }

    public static void restoreEntities() {
        for (Map.Entry<UUID, Entity<? extends LivingEntity>> entry : ENTITIES.entrySet()) {
            entry.getValue().onLoad();
            entry.getValue().applyGoals();
            entry.getValue().applyAttributes();
        }
        AbyssalLib.LOGGER.info("Loaded " + ENTITIES.size() + " entities");
    }

    public static void runSpawnCycle(World world) throws CloneNotSupportedException {
        List players = world.getPlayers();
        if (players.isEmpty()) {
            return;
        }
        HashSet<Chunk> eligibleChunks = new HashSet<Chunk>();
        for (Player player : players) {
            int chunkRadius = 8;
            Chunk center = player.getLocation().getChunk();
            for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
                for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
                    Chunk chunk = world.getChunkAt(center.getX() + dx, center.getZ() + dz);
                    eligibleChunks.add(chunk);
                }
            }
        }
        int totalLoaded = world.getLoadedChunks().length;
        for (SpawnCategory category : SpawnCategory.values()) {
            Location spawnLoc;
            Chunk randomChunk;
            int allowed;
            int currentCount;
            int cap;
            switch (category) {
                default: {
                    throw new MatchException(null, null);
                }
                case MONSTER: {
                    int n = AbyssalLib.CONFIG.spawnLimits.monster.get();
                    break;
                }
                case CREATURE: {
                    int n = AbyssalLib.CONFIG.spawnLimits.creature.get();
                    break;
                }
                case AMBIENT: {
                    int n = AbyssalLib.CONFIG.spawnLimits.ambient.get();
                    break;
                }
                case WATER_MONSTER: {
                    int n = AbyssalLib.CONFIG.spawnLimits.waterMonster.get();
                    break;
                }
                case WATER_CREATURE: {
                    int n = AbyssalLib.CONFIG.spawnLimits.waterCreature.get();
                    break;
                }
                case WATER_AMBIENT: {
                    int n = cap = AbyssalLib.CONFIG.spawnLimits.waterAmbient.get().intValue();
                }
            }
            if (cap <= 0 || (currentCount = EntityManager.countEntities(world, category)) >= (allowed = cap * eligibleChunks.size() / Math.max(totalLoaded, 1)) || (randomChunk = (Chunk)eligibleChunks.stream().skip(rand.nextInt(eligibleChunks.size())).findFirst().orElse(null)) == null || (spawnLoc = EntityManager.getRandomLocationInChunk(randomChunk, world, category)) == null) continue;
            EntityManager.spawnCustomEntity(world, spawnLoc, category);
        }
    }

    private static int countEntities(World world, SpawnCategory category) {
        int count = 0;
        ArrayList entities = new ArrayList();
        world.getEntities().forEach(e -> entities.add(Entity.resolve(e)));
        for (Entity e2 : entities) {
            if (e2 == null || e2.getCategory() != category) continue;
            ++count;
        }
        return count;
    }

    private static Location getRandomLocationInChunk(Chunk chunk, World world, SpawnCategory category) {
        int x = (chunk.getX() << 4) + rand.nextInt(16);
        int z = (chunk.getZ() << 4) + rand.nextInt(16);
        if (!world.getWorldBorder().isInside(new Location(world, (double)x, (double)world.getSeaLevel(), (double)z))) {
            return null;
        }
        switch (category) {
            case WATER_MONSTER: 
            case WATER_CREATURE: 
            case WATER_AMBIENT: {
                int highestY;
                for (int y = highestY = world.getHighestBlockYAt(x, z); y > 5; --y) {
                    Location loc = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
                    if (!loc.getBlock().isLiquid() || !loc.clone().add(0.0, 1.0, 0.0).getBlock().isLiquid() || !loc.clone().add(0.0, -1.0, 0.0).getBlock().isLiquid() || !loc.clone().add(0.0, 3.0, 0.0).getBlock().isLiquid()) continue;
                    return loc;
                }
                return null;
            }
            case MONSTER: 
            case CREATURE: 
            case AMBIENT: {
                int highestY;
                for (int y = highestY = world.getHighestBlockYAt(x, z); y > 0; --y) {
                    Location spawn;
                    Location ground = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
                    if (!ground.getBlock().getType().isSolid() || !(spawn = ground.clone().add(0.0, 1.0, 0.0)).getBlock().isEmpty() || !spawn.clone().add(0.0, 1.0, 0.0).getBlock().isEmpty()) continue;
                    return spawn;
                }
                return null;
            }
        }
        return null;
    }

    private static void spawnCustomEntity(World world, Location loc, SpawnCategory category) {
        Entity.EntityEntry entry = Entity.getWeighedSpawnEntry(loc.getBlock().getBiome(), category);
        if (entry == null) {
            return;
        }
        float chance = entry.entry().weight();
        if (rand.nextFloat() > chance) {
            return;
        }
        for (BiPredicate<World, Location> condition : entry.entity().getSpawnConditions()) {
            if (condition.test(world, loc)) continue;
            return;
        }
        int groupSize = entry.entry().maxGroup() + rand.nextInt(entry.entry().maxGroup() - entry.entry().minGroup() + 1);
        for (int i = 0; i < groupSize; ++i) {
            Location offset = loc.clone().add((double)(rand.nextInt(3) - 1), 0.0, (double)(rand.nextInt(3) - 1));
            ((Entity)entry.entity().clone()).spawn(offset, EntitySpawnEvent.SpawnReason.NATURAL);
            AbyssalLib.LOGGER.info("Spawned " + String.valueOf(entry.entity().getId()) + "at " + String.valueOf(offset));
        }
    }
}

