/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.gui;

import com.github.darksoulq.abyssallib.world.gui.Gui;
import com.github.darksoulq.abyssallib.world.gui.GuiElement;
import com.github.darksoulq.abyssallib.world.gui.GuiFlag;
import com.github.darksoulq.abyssallib.world.gui.GuiLayer;
import com.github.darksoulq.abyssallib.world.gui.GuiView;
import com.github.darksoulq.abyssallib.world.gui.SlotPosition;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.MenuType;

public abstract class AbstractGui
extends Gui {
    public AbstractGui(MenuType menuType, Component title) {
        super(menuType, title, new HashMap<SlotPosition, GuiElement>(), new LinkedList<GuiLayer>(), new LinkedList<Consumer<GuiView>>(), EnumSet.noneOf(GuiFlag.class), null, null);
        this.init();
        this.onOpen = this::onOpen;
        this.onClose = this::onClose;
    }

    protected abstract void init();

    protected abstract void onOpen(GuiView var1);

    protected abstract void onClose(GuiView var1);

    public void set(SlotPosition pos, GuiElement element) {
        this.getElements().put(pos, element);
    }

    public void addFlag(GuiFlag flag) {
        this.getFlags().add(flag);
    }

    public void addFlags(GuiFlag ... flags) {
        this.getFlags().addAll(List.of(flags));
    }

    public void addLayer(GuiLayer layer) {
        this.getLayers().add(layer);
    }
}

