/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.gui;

import com.github.darksoulq.abyssallib.world.gui.GuiElement;
import com.github.darksoulq.abyssallib.world.gui.GuiFlag;
import com.github.darksoulq.abyssallib.world.gui.GuiLayer;
import com.github.darksoulq.abyssallib.world.gui.GuiView;
import com.github.darksoulq.abyssallib.world.gui.SlotPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.MenuType;

public class Gui {
    private final MenuType menuType;
    private final Component title;
    private final Map<SlotPosition, GuiElement> elements = new HashMap<SlotPosition, GuiElement>();
    private final List<GuiLayer> layers = new ArrayList<GuiLayer>();
    private final List<Consumer<GuiView>> tickers = new ArrayList<Consumer<GuiView>>();
    private final EnumSet<GuiFlag> flags;
    Consumer<GuiView> onOpen;
    Consumer<GuiView> onClose;

    public Gui(MenuType menuType, Component title, Map<SlotPosition, GuiElement> elements, List<GuiLayer> layers, List<Consumer<GuiView>> tickers, EnumSet<GuiFlag> flags, Consumer<GuiView> onOpen, Consumer<GuiView> onClose) {
        this.menuType = menuType;
        this.title = title;
        this.elements.putAll(elements);
        this.layers.addAll(layers);
        this.tickers.addAll(tickers);
        this.flags = flags;
        this.onOpen = onOpen;
        this.onClose = onClose;
    }

    public MenuType getMenuType() {
        return this.menuType;
    }

    public Consumer<GuiView> getOnClose() {
        return this.onClose;
    }

    public Consumer<GuiView> getOnOpen() {
        return this.onOpen;
    }

    public List<Consumer<GuiView>> getTickers() {
        return this.tickers;
    }

    public List<GuiLayer> getLayers() {
        return this.layers;
    }

    public Map<SlotPosition, GuiElement> getElements() {
        return this.elements;
    }

    public boolean hasFlag(GuiFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public EnumSet<GuiFlag> getFlags() {
        return this.flags;
    }

    public Component getTitle() {
        return this.title;
    }

    public static class Builder {
        private final MenuType menuType;
        private final Component title;
        private final Map<SlotPosition, GuiElement> elements = new HashMap<SlotPosition, GuiElement>();
        private final List<GuiLayer> layers = new ArrayList<GuiLayer>();
        private final List<Consumer<GuiView>> tickers = new ArrayList<Consumer<GuiView>>();
        private final EnumSet<GuiFlag> flags = EnumSet.noneOf(GuiFlag.class);
        private Consumer<GuiView> onOpen = v -> {};
        private Consumer<GuiView> onClose = v -> {};

        public Builder(MenuType menuType, Component title) {
            this.menuType = menuType;
            this.title = title;
        }

        public Builder set(SlotPosition pos, GuiElement element) {
            this.elements.put(pos, element);
            return this;
        }

        public Builder addLayer(GuiLayer layer) {
            this.layers.add(layer);
            return this;
        }

        public Builder onTick(Consumer<GuiView> tick) {
            this.tickers.add(tick);
            return this;
        }

        public Builder onOpen(Consumer<GuiView> handler) {
            this.onOpen = handler;
            return this;
        }

        public Builder onClose(Consumer<GuiView> handler) {
            this.onClose = handler;
            return this;
        }

        public Builder addFlag(GuiFlag flag) {
            this.flags.add(flag);
            return this;
        }

        public Builder addFlags(GuiFlag ... flags) {
            this.flags.addAll(Arrays.asList(flags));
            return this;
        }

        public Gui build() {
            return new Gui(this.menuType, this.title, this.elements, this.layers, this.tickers, this.flags, this.onOpen, this.onClose);
        }
    }
}

