/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.gui;

import com.github.darksoulq.abyssallib.world.gui.Gui;
import com.github.darksoulq.abyssallib.world.gui.GuiElement;
import com.github.darksoulq.abyssallib.world.gui.SlotPosition;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class GuiView {
    private final Gui gui;
    private final InventoryView view;

    public GuiView(Gui gui, InventoryView view) {
        this.gui = gui;
        this.view = view;
    }

    public Gui getGui() {
        return this.gui;
    }

    public InventoryView getInventoryView() {
        return this.view;
    }

    public Inventory getTop() {
        return this.view.getTopInventory();
    }

    public Inventory getBottom() {
        return this.view.getBottomInventory();
    }

    public void tick() {
        Inventory top = this.getTop();
        Inventory bot = this.getBottom();
        this.gui.getLayers().forEach(layer -> layer.renderTo(this));
        this.gui.getTickers().forEach(t -> t.accept(this));
        this.gui.getElements().forEach((s, e) -> {
            ItemStack item = e.render(this, s.index());
            if (item != null) {
                if (s.segment() == Segment.TOP) {
                    if (top.getItem(s.index()) != item) {
                        top.setItem(s.index(), item);
                    }
                } else if (bot.getItem(s.index()) != item) {
                    bot.setItem(s.index(), item);
                }
            }
        });
    }

    public void close(HumanEntity player) {
        player.closeInventory();
        this.gui.getOnClose().accept(this);
    }

    public GuiElement getElementAt(Segment segment, int slot) {
        return this.gui.getElements().get(new SlotPosition(segment, slot));
    }

    public static enum Segment {
        TOP,
        BOTTOM;

    }
}

