/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.gui;

import com.github.darksoulq.abyssallib.world.gui.GuiView;
import com.github.darksoulq.abyssallib.world.gui.SlotPosition;
import java.util.ArrayList;
import java.util.List;

public final class SlotUtil {
    private SlotUtil() {
    }

    public static List<SlotPosition> border(GuiView.Segment segment, int startSlot, int rows, int cols, int maxRows, int maxCols) {
        int row;
        ArrayList<SlotPosition> positions = new ArrayList<SlotPosition>();
        int startRow = startSlot / maxCols;
        int startCol = startSlot % maxCols;
        for (int r = 0; r < rows && (row = startRow + r) < maxRows; ++r) {
            for (int c = 0; c < cols; ++c) {
                boolean isEdge;
                int col = startCol + c;
                if (col >= maxCols) continue;
                boolean bl = isEdge = r == 0 || r == rows - 1 || c == 0 || c == cols - 1;
                if (!isEdge) continue;
                positions.add(new SlotPosition(segment, row * maxCols + col));
            }
        }
        return positions;
    }

    public static List<SlotPosition> row(GuiView.Segment segment, int startSlot, int length, int maxCols) {
        int col;
        ArrayList<SlotPosition> positions = new ArrayList<SlotPosition>();
        int startRow = startSlot / maxCols;
        int startCol = startSlot % maxCols;
        for (int i = 0; i < length && (col = startCol + i) < maxCols; ++i) {
            int slot = startRow * maxCols + col;
            positions.add(new SlotPosition(segment, slot));
        }
        return positions;
    }

    public static List<SlotPosition> column(GuiView.Segment segment, int startSlot, int step, int length, int maxRows, int maxCols) {
        int row;
        ArrayList<SlotPosition> positions = new ArrayList<SlotPosition>();
        int startRow = startSlot / maxCols;
        int startCol = startSlot % maxCols;
        for (int i = 0; i < length && (row = startRow + i * step) < maxRows; ++i) {
            int slot = row * maxCols + startCol;
            positions.add(new SlotPosition(segment, slot));
        }
        return positions;
    }

    public static List<SlotPosition> grid(GuiView.Segment segment, int startSlot, int rows, int cols, int maxRows, int maxCols) {
        int row;
        ArrayList<SlotPosition> positions = new ArrayList<SlotPosition>();
        int startRow = startSlot / maxCols;
        int startCol = startSlot % maxCols;
        for (int r = 0; r < rows && (row = startRow + r) < maxRows; ++r) {
            for (int c = 0; c < cols; ++c) {
                int col = startCol + c;
                if (col >= maxCols) continue;
                positions.add(new SlotPosition(segment, row * maxCols + col));
            }
        }
        return positions;
    }

    public static List<SlotPosition> pattern(GuiView.Segment segment, int startSlot, int maxRows, int maxCols, int ... offsets) {
        ArrayList<SlotPosition> positions = new ArrayList<SlotPosition>();
        int startRow = startSlot / maxCols;
        int startCol = startSlot % maxCols;
        for (int offset : offsets) {
            int row = startRow + offset / maxCols;
            int col = startCol + offset % maxCols;
            if (row < 0 || row >= maxRows || col < 0 || col >= maxCols) continue;
            positions.add(new SlotPosition(segment, row * maxCols + col));
        }
        return positions;
    }
}

