/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.item.map;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.world.data.internal.MapLoader;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class BaseMap {
    private final Plugin plugin;
    protected final MapView mapView;

    public BaseMap(Plugin plugin, MapView mapView) {
        this.plugin = plugin;
        this.mapView = mapView;
        mapView.getRenderers().clear();
        mapView.addRenderer(new MapRenderer(){

            public void render(@NotNull MapView view, @NotNull MapCanvas canvas, @NotNull Player player) {
                BaseMap.this.render(canvas, player);
            }
        });
        AbyssalLib.EVENT_BUS.register(this);
        this.saveMetadata();
    }

    public ItemStack createMapItem(Component name, List<Component> lore) {
        ItemStack item = new ItemStack(Material.FILLED_MAP);
        MapMeta meta = (MapMeta)item.getItemMeta();
        meta.setMapView(this.mapView);
        if (name != null) {
            meta.itemName(name);
        }
        if (lore != null) {
            meta.lore(lore);
        }
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    protected void saveMetadata() {
        MapLoader.saveMetadata(this, this.getClass(), this.mapView.getId());
    }

    protected abstract void render(MapCanvas var1, Player var2);
}

