/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.multiblock;

import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.github.darksoulq.abyssallib.world.multiblock.MultiblockChoice;
import com.github.darksoulq.abyssallib.world.multiblock.MultiblockData;
import com.github.darksoulq.abyssallib.world.multiblock.MultiblockInstance;
import com.github.darksoulq.abyssallib.world.multiblock.RelativeBlockPos;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public abstract class Multiblock {
    private final Identifier id;
    private final Class<? extends MultiblockData> dataClass;
    private final Map<RelativeBlockPos, MultiblockChoice> pattern = new HashMap<RelativeBlockPos, MultiblockChoice>();
    private int[] min = new int[3];
    private int[] max = new int[3];

    public Multiblock(Identifier id, Class<? extends MultiblockData> dataClass) {
        this.id = id;
        this.dataClass = dataClass;
        Arrays.fill(this.min, 0);
        Arrays.fill(this.max, 0);
    }

    public Multiblock(Identifier id) {
        this.id = id;
        this.dataClass = EmptyData.class;
        Arrays.fill(this.min, 0);
        Arrays.fill(this.max, 0);
    }

    protected void structure(int x, int y, int z, MultiblockChoice choice) {
        this.pattern.put(new RelativeBlockPos(x, y, z), choice);
        this.updateBounds(x, y, z);
    }

    private void updateBounds(int x, int y, int z) {
        if (x < this.min[0]) {
            this.min[0] = x;
        }
        if (y < this.min[1]) {
            this.min[1] = y;
        }
        if (z < this.min[2]) {
            this.min[2] = z;
        }
        if (x > this.max[0]) {
            this.max[0] = x;
        }
        if (y > this.max[1]) {
            this.max[1] = y;
        }
        if (z > this.max[2]) {
            this.max[2] = z;
        }
    }

    public Identifier getId() {
        return this.id;
    }

    public boolean matchesAt(Block origin) {
        for (Map.Entry<RelativeBlockPos, MultiblockChoice> e : this.pattern.entrySet()) {
            Block b = origin.getRelative(e.getKey().x(), e.getKey().y(), e.getKey().z());
            if (e.getValue().matches(b)) continue;
            return false;
        }
        return true;
    }

    public Block findOriginFrom(Block clicked) {
        int minX = this.min[0];
        int minY = this.min[1];
        int minZ = this.min[2];
        int maxX = this.max[0];
        int maxY = this.max[1];
        int maxZ = this.max[2];
        for (int dy = minY; dy <= maxY; ++dy) {
            for (int dx = minX; dx <= maxX; ++dx) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    Block cand = clicked.getRelative(dx, dy, dz);
                    if (!this.matchesAt(cand)) continue;
                    return cand;
                }
            }
        }
        return null;
    }

    public MultiblockData createData() {
        try {
            return this.dataClass != null ? this.dataClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create MultiblockData", e);
        }
    }

    public MultiblockData deserializeData(String json) {
        return this.dataClass != null ? (MultiblockData)TextUtil.GSON.fromJson(json, this.dataClass) : null;
    }

    public Map<RelativeBlockPos, MultiblockChoice> getPattern() {
        return this.pattern;
    }

    public boolean isTrigger(Block clicked) {
        return true;
    }

    public void onActivate(Player player, MultiblockInstance instance) {
    }

    public void onInteract(Player player, MultiblockInstance inst, Block clicked) {
    }

    public void onBreak(Player breaker, MultiblockInstance inst, Block brokenPart) {
    }

    public static class EmptyData
    extends MultiblockData {
    }
}

