/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.particle;

import com.github.darksoulq.abyssallib.world.particle.Shape;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.joml.Matrix3f;
import org.joml.Vector3f;

public class AnimatedShapes {
    public static Shape rotatingCircle(double radius, int points, double rotationSpeed) {
        return (origin, tick, builder) -> {
            List<Location> buffer = builder.getLocationBuffer(points);
            double angleOffset = (double)tick * rotationSpeed % (Math.PI * 2);
            for (int i = 0; i < points; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)points + angleOffset;
                double x = Math.cos(angle) * radius;
                double z = Math.sin(angle) * radius;
                buffer.set(i, builder.poolLocation(origin.getX() + x, origin.getY(), origin.getZ() + z));
            }
            return buffer;
        };
    }

    public static Shape rotatingSphere(double radius, int points, double rotationSpeed) {
        return (origin, tick, builder) -> {
            List<Location> buffer = builder.getLocationBuffer(points);
            Random rand = new Random(tick);
            for (int i = 0; i < points; ++i) {
                double theta = Math.PI * 2 * rand.nextDouble();
                double phi = Math.acos(2.0 * rand.nextDouble() - 1.0);
                double angleOffset = (double)tick * rotationSpeed % (Math.PI * 2);
                double x = radius * Math.sin(phi) * Math.cos(theta + angleOffset);
                double y = radius * Math.sin(phi) * Math.sin(theta + angleOffset);
                double z = radius * Math.cos(phi);
                buffer.set(i, builder.poolLocation(origin.getX() + x, origin.getY() + y, origin.getZ() + z));
            }
            return buffer;
        };
    }

    public static Shape cubeEdges(double size, int pointsPerEdge) {
        int totalPoints = pointsPerEdge * 12;
        return (origin, tick, builder) -> {
            int i;
            List<Location> buffer = builder.getLocationBuffer(totalPoints);
            double half = size / 2.0;
            int idx = 0;
            double[] xs = new double[]{-half, half};
            double[] ys = new double[]{-half, half};
            double[] zs = new double[]{-half, half};
            for (double x : xs) {
                for (double y : ys) {
                    for (i = 0; i < pointsPerEdge; ++i) {
                        buffer.set(idx++, builder.poolLocation(origin.getX() + x, origin.getY() + y, origin.getZ() - half + (double)i * (size / (double)(pointsPerEdge - 1))));
                    }
                }
            }
            for (double x : xs) {
                for (double z : zs) {
                    for (i = 0; i < pointsPerEdge; ++i) {
                        buffer.set(idx++, builder.poolLocation(origin.getX() + x, origin.getY() - half + (double)i * (size / (double)(pointsPerEdge - 1)), origin.getZ() + z));
                    }
                }
            }
            for (double y : ys) {
                for (double z : zs) {
                    for (i = 0; i < pointsPerEdge; ++i) {
                        buffer.set(idx++, builder.poolLocation(origin.getX() - half + (double)i * (size / (double)(pointsPerEdge - 1)), origin.getY() + y, origin.getZ() + z));
                    }
                }
            }
            return buffer;
        };
    }

    public static Shape rotatingDiamondCube(double size, int pointsPerEdge, double rotationSpeed) {
        int totalPoints = pointsPerEdge * 12;
        return (origin, tick, builder) -> {
            Vector3f v;
            int i;
            List<Location> buffer = builder.getLocationBuffer(totalPoints);
            double half = size / 2.0;
            int idx = 0;
            double[] xs = new double[]{-half, half};
            double[] ys = new double[]{-half, half};
            double[] zs = new double[]{-half, half};
            float angle = (float)((double)tick * rotationSpeed);
            Matrix3f rot = new Matrix3f().rotateXYZ(angle, angle, angle);
            for (double x : xs) {
                for (double y : ys) {
                    for (i = 0; i < pointsPerEdge; ++i) {
                        v = new Vector3f((float)x, (float)y, (float)(-half + (double)i * (size / (double)(pointsPerEdge - 1))));
                        rot.transform(v);
                        buffer.set(idx++, builder.poolLocation(origin.getX() + (double)v.x, origin.getY() + (double)v.y, origin.getZ() + (double)v.z));
                    }
                }
            }
            for (double x : xs) {
                for (double z : zs) {
                    for (i = 0; i < pointsPerEdge; ++i) {
                        v = new Vector3f((float)x, (float)(-half + (double)i * (size / (double)(pointsPerEdge - 1))), (float)z);
                        rot.transform(v);
                        buffer.set(idx++, builder.poolLocation(origin.getX() + (double)v.x, origin.getY() + (double)v.y, origin.getZ() + (double)v.z));
                    }
                }
            }
            for (double y : ys) {
                for (double z : zs) {
                    for (i = 0; i < pointsPerEdge; ++i) {
                        v = new Vector3f((float)(-half + (double)i * (size / (double)(pointsPerEdge - 1))), (float)y, (float)z);
                        rot.transform(v);
                        buffer.set(idx++, builder.poolLocation(origin.getX() + (double)v.x, origin.getY() + (double)v.y, origin.getZ() + (double)v.z));
                    }
                }
            }
            return buffer;
        };
    }
}

