/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.particle;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.world.particle.ParticleEmitter;
import com.github.darksoulq.abyssallib.world.particle.Shape;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public final class Particles {
    private static final Random RANDOM = new Random();
    private final Particle type;
    private final ItemStack displayItem;
    private final Location origin;
    private final ParticleEmitter emitter;
    private final int count;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final double speed;
    private final Shape shape;
    private final float scaleX;
    private final float scaleY;
    private final float scaleZ;
    private final Display.Billboard billboard;
    private final float xRotDeg;
    private final float yRotDeg;
    private final float zRotDeg;
    private final Object data;
    private final long interval;
    private final long duration;
    private final BooleanSupplier cancelIf;
    private final List<Player> viewers;
    private final boolean asyncShape;
    private final Quaternionf precomputedRotation;
    private final LocationPool locationPool = new LocationPool();
    private final List<ItemDisplay> spawnedDisplays = new ArrayList<ItemDisplay>();
    private BukkitTask task;

    private Particles(Builder b) {
        this.type = b.type;
        this.displayItem = b.displayItem;
        this.origin = b.origin;
        this.emitter = b.emitter;
        this.count = b.count;
        this.offsetX = b.offsetX;
        this.offsetY = b.offsetY;
        this.offsetZ = b.offsetZ;
        this.speed = b.speed;
        this.shape = b.shape;
        this.scaleX = b.scaleX;
        this.scaleY = b.scaleY;
        this.scaleZ = b.scaleZ;
        this.billboard = b.billboard;
        this.xRotDeg = b.xRotDeg;
        this.yRotDeg = b.yRotDeg;
        this.zRotDeg = b.zRotDeg;
        this.data = b.data;
        this.interval = b.interval;
        this.duration = b.duration;
        this.cancelIf = b.cancelIf;
        this.viewers = b.viewers;
        this.asyncShape = b.asyncShape;
        this.precomputedRotation = new Quaternionf().rotateX((float)Math.toRadians(this.xRotDeg)).rotateY((float)Math.toRadians(this.yRotDeg)).rotateZ((float)Math.toRadians(this.zRotDeg));
    }

    public void start() {
        if (this.origin == null && this.emitter == null) {
            throw new IllegalStateException("Origin or emitter required");
        }
        this.stop();
        long[] elapsed = new long[]{0L};
        Runnable tickRunnable = () -> {
            Location base;
            Location location = base = this.emitter != null ? this.emitter.getLocation() : this.origin;
            if (base == null || this.cancelIf != null && this.cancelIf.getAsBoolean()) {
                this.stop();
                return;
            }
            if (this.asyncShape && this.shape != null) {
                long tickNow = elapsed[0];
                CompletableFuture.supplyAsync(() -> this.shape.points(base, tickNow, this)).thenAccept(points -> Bukkit.getScheduler().runTask((Plugin)AbyssalLib.getInstance(), () -> this.spawnAt((List<Location>)points)));
            } else {
                List<Location> points2 = this.shape != null ? this.shape.points(base, elapsed[0], this) : this.randomPoints(base);
                this.spawnAt(points2);
            }
            elapsed[0] = elapsed[0] + this.interval;
            if (this.duration > 0L && elapsed[0] >= this.duration) {
                this.stop();
            }
        };
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)AbyssalLib.getInstance(), tickRunnable, 0L, this.interval);
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (!this.spawnedDisplays.isEmpty()) {
            for (ItemDisplay d : this.spawnedDisplays) {
                if (d == null || d.isDead()) continue;
                d.remove();
            }
            this.spawnedDisplays.clear();
        }
        this.locationPool.clear();
    }

    public Location poolLocation(double x, double y, double z) {
        Location loc = this.locationPool.acquire(this.origin.getWorld());
        loc.set(x, y, z);
        return loc;
    }

    public List<Location> getLocationBuffer(int size) {
        ArrayList<Location> list = new ArrayList<Location>(size);
        World w = this.origin.getWorld();
        for (int i = 0; i < size; ++i) {
            list.add(this.locationPool.acquire(w));
        }
        return list;
    }

    private List<Location> randomPoints(Location base) {
        ArrayList<Location> pts = new ArrayList<Location>(this.count);
        World w = base.getWorld();
        for (int i = 0; i < this.count; ++i) {
            Location l = this.locationPool.acquire(w);
            l.setX(base.getX() + (RANDOM.nextDouble() - 0.5) * this.offsetX * 2.0);
            l.setY(base.getY() + (RANDOM.nextDouble() - 0.5) * this.offsetY * 2.0);
            l.setZ(base.getZ() + (RANDOM.nextDouble() - 0.5) * this.offsetZ * 2.0);
            pts.add(l);
        }
        return pts;
    }

    public void spawnAt(List<Location> points) {
        if (points == null || points.isEmpty()) {
            return;
        }
        if (this.displayItem == null) {
            this.spawnBukkitParticles(points);
        } else {
            this.spawnItemDisplays(points);
        }
        for (Location l : points) {
            this.locationPool.release(l);
        }
    }

    private void spawnBukkitParticles(List<Location> points) {
        if (this.viewers != null && !this.viewers.isEmpty()) {
            for (Player p : this.viewers) {
                for (Location pt : points) {
                    if (this.data != null) {
                        p.spawnParticle(this.type, pt, 1, this.offsetX, this.offsetY, this.offsetZ, this.speed, this.data);
                        continue;
                    }
                    p.spawnParticle(this.type, pt, 1, this.offsetX, this.offsetY, this.offsetZ, this.speed);
                }
            }
        } else {
            for (Location pt : points) {
                World w = pt.getWorld();
                if (w == null) continue;
                if (this.data != null) {
                    w.spawnParticle(this.type, pt, 1, this.offsetX, this.offsetY, this.offsetZ, this.speed, this.data);
                    continue;
                }
                w.spawnParticle(this.type, pt, 1, this.offsetX, this.offsetY, this.offsetZ, this.speed);
            }
        }
    }

    private void spawnItemDisplays(List<Location> points) {
        for (ItemDisplay d : this.spawnedDisplays) {
            if (d == null || d.isDead()) continue;
            d.remove();
        }
        this.spawnedDisplays.clear();
        for (Location pt : points) {
            World w = pt.getWorld();
            if (w == null) continue;
            ItemDisplay d = (ItemDisplay)w.spawn(pt.clone(), ItemDisplay.class);
            d.setItemStack(this.displayItem.clone());
            d.setBillboard(this.billboard);
            Transformation transform = d.getTransformation();
            transform.getScale().set(this.scaleX, this.scaleY, this.scaleZ);
            transform.getLeftRotation().set((Quaternionfc)this.precomputedRotation);
            d.setTransformation(transform);
            this.spawnedDisplays.add(d);
        }
        if (this.viewers != null && !this.viewers.isEmpty()) {
            for (ItemDisplay d : this.spawnedDisplays) {
                d.setVisibleByDefault(false);
                for (Player p : this.viewers) {
                    p.showEntity((Plugin)AbyssalLib.getInstance(), (Entity)d);
                }
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class LocationPool {
        private final Deque<Location> pool = new ArrayDeque<Location>(64);

        private LocationPool() {
        }

        Location acquire(World w) {
            Location l = this.pool.pollFirst();
            if (l == null) {
                return new Location(w, 0.0, 0.0, 0.0);
            }
            l.setWorld(w);
            return l;
        }

        void release(Location l) {
            if (l != null) {
                l.setWorld(null);
                this.pool.offerFirst(l);
            }
        }

        void clear() {
            this.pool.clear();
        }
    }

    public static final class Builder {
        private Particle type;
        private ItemStack displayItem;
        private Location origin;
        private ParticleEmitter emitter;
        private int count = 1;
        private double offsetX;
        private double offsetY;
        private double offsetZ;
        private double speed;
        private Shape shape;
        private float scaleX = 1.0f;
        private float scaleY = 1.0f;
        private float scaleZ = 1.0f;
        private Display.Billboard billboard = Display.Billboard.HORIZONTAL;
        private float xRotDeg;
        private float yRotDeg;
        private float zRotDeg;
        private Object data;
        private long interval = 1L;
        private long duration = -1L;
        private BooleanSupplier cancelIf;
        private List<Player> viewers;
        private boolean asyncShape = false;

        public Builder particle(Particle p) {
            this.type = p;
            return this;
        }

        public Builder display(ItemStack item) {
            this.displayItem = item;
            return this;
        }

        public Builder spawnAt(Location loc) {
            this.origin = loc;
            return this;
        }

        public Builder spawnAt(ParticleEmitter e) {
            this.emitter = e;
            return this;
        }

        public Builder count(int c) {
            this.count = c;
            return this;
        }

        public Builder offset(double x, double y, double z) {
            this.offsetX = x;
            this.offsetY = y;
            this.offsetZ = z;
            return this;
        }

        public Builder speed(double s) {
            this.speed = s;
            return this;
        }

        public Builder shape(Shape s) {
            this.shape = s;
            return this;
        }

        public Builder scale(float s) {
            return this.scale(s, s, s);
        }

        public Builder scale(float x, float y, float z) {
            this.scaleX = x;
            this.scaleY = y;
            this.scaleZ = z;
            return this;
        }

        public Builder billboard(Display.Billboard b) {
            this.billboard = b;
            return this;
        }

        public Builder rotation(float xDeg, float yDeg, float zDeg) {
            this.xRotDeg = xDeg;
            this.yRotDeg = yDeg;
            this.zRotDeg = zDeg;
            return this;
        }

        public Builder data(Object d) {
            this.data = d;
            return this;
        }

        public Builder interval(long ticks) {
            this.interval = ticks;
            return this;
        }

        public Builder duration(long ticks) {
            this.duration = ticks;
            return this;
        }

        public Builder cancelIf(BooleanSupplier s) {
            this.cancelIf = s;
            return this;
        }

        public Builder viewers(List<Player> vs) {
            this.viewers = vs;
            return this;
        }

        public Builder viewers(Player single) {
            this.viewers = Collections.singletonList(single);
            return this;
        }

        public Builder asyncShape(boolean v) {
            this.asyncShape = v;
            return this;
        }

        public Particles build() {
            if (this.type == null && this.displayItem == null) {
                throw new IllegalStateException("Need either particle type or display item");
            }
            return new Particles(this);
        }
    }
}

