/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.particle;

import com.github.darksoulq.abyssallib.world.particle.Shape;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;

public final class Shapes {
    private static final Random RANDOM = new Random();

    private Shapes() {
    }

    public static Shape circle(double radius, int points) {
        return (origin, tick, particles) -> {
            List<Location> list = particles.getLocationBuffer(points);
            for (int i = 0; i < points; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)points;
                double x = Math.cos(angle) * radius;
                double z = Math.sin(angle) * radius;
                list.set(i, particles.poolLocation(origin.getX() + x, origin.getY(), origin.getZ() + z));
            }
            return list;
        };
    }

    public static Shape sphere(double radius, int points) {
        return (origin, tick, particles) -> {
            List<Location> list = particles.getLocationBuffer(points);
            for (int i = 0; i < points; ++i) {
                double theta = Math.PI * 2 * RANDOM.nextDouble();
                double phi = Math.acos(2.0 * RANDOM.nextDouble() - 1.0);
                double x = radius * Math.sin(phi) * Math.cos(theta);
                double y = radius * Math.sin(phi) * Math.sin(theta);
                double z = radius * Math.cos(phi);
                list.set(i, particles.poolLocation(origin.getX() + x, origin.getY() + y, origin.getZ() + z));
            }
            return list;
        };
    }

    public static Shape cubeEdges(double size, int pointsPerEdge) {
        return (origin, tick, particles) -> {
            int i;
            int totalPoints = pointsPerEdge * 12;
            List<Location> list = particles.getLocationBuffer(totalPoints);
            double half = size / 2.0;
            int idx = 0;
            double[] xs = new double[]{-half, half};
            double[] ys = new double[]{-half, half};
            double[] zs = new double[]{-half, half};
            for (double x : xs) {
                for (double y : ys) {
                    for (i = 0; i < pointsPerEdge; ++i) {
                        list.set(idx++, particles.poolLocation(origin.getX() + x, origin.getY() + y, origin.getZ() - half + (double)i * (size / (double)(pointsPerEdge - 1))));
                    }
                }
            }
            for (double x : xs) {
                for (double z : zs) {
                    for (i = 0; i < pointsPerEdge; ++i) {
                        list.set(idx++, particles.poolLocation(origin.getX() + x, origin.getY() - half + (double)i * (size / (double)(pointsPerEdge - 1)), origin.getZ() + z));
                    }
                }
            }
            for (double y : ys) {
                for (double z : zs) {
                    for (i = 0; i < pointsPerEdge; ++i) {
                        list.set(idx++, particles.poolLocation(origin.getX() - half + (double)i * (size / (double)(pointsPerEdge - 1)), origin.getY() + y, origin.getZ() + z));
                    }
                }
            }
            return list;
        };
    }

    public static Shape pyramid(double height, int points) {
        return (origin, tick, particles) -> {
            List<Location> list = particles.getLocationBuffer(points);
            for (int i = 0; i < points; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)points;
                double x = Math.cos(angle) * height;
                double z = Math.sin(angle) * height;
                list.set(i, particles.poolLocation(origin.getX() + x, origin.getY(), origin.getZ() + z + height));
            }
            return list;
        };
    }
}

