/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.recipe;

import com.github.darksoulq.abyssallib.common.serialization.Codec;
import com.github.darksoulq.abyssallib.common.serialization.Codecs;
import com.github.darksoulq.abyssallib.common.serialization.ops.YamlOps;
import com.github.darksoulq.abyssallib.common.util.FileUtils;
import com.github.darksoulq.abyssallib.server.registry.Registries;
import io.papermc.paper.potion.PotionMix;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.TransmuteRecipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;

public class RecipeLoader {
    private static final Map<String, RecipeHandler> HANDLERS = new HashMap<String, RecipeHandler>();

    public static void registerHandler(String type, RecipeHandler handler) {
        HANDLERS.put(type, handler);
    }

    public static void loadFolder(File folder) {
        if (!folder.exists() || !folder.isDirectory()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                RecipeLoader.loadFolder(file);
                continue;
            }
            if (!file.getName().endsWith(".yml") && !file.getName().endsWith(".yaml")) continue;
            RecipeLoader.loadFile(file);
        }
    }

    public static void loadFolder(Plugin plugin, String resourcePath) {
        List<String> files = FileUtils.getFilePathList(plugin, resourcePath);
        for (String file : files) {
            try {
                InputStream in = plugin.getResource(file);
                try {
                    if (in == null) continue;
                    RecipeLoader.loadFile(in);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (Exception e) {
                plugin.getLogger().warning("Failed to load recipe resource: " + file + " - " + e.getMessage());
            }
        }
    }

    public static void loadFile(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            RecipeLoader.loadFile(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadFile(InputStream in) throws Codec.CodecException {
        Object root = YamlOps.INSTANCE.parse(in);
        if (root instanceof List) {
            List list = (List)root;
            RecipeLoader.decode(list);
        } else {
            RecipeLoader.decode(Collections.singletonList(root));
        }
    }

    private static void decode(List<?> recipes) throws Codec.CodecException {
        for (Object recipe : recipes) {
            Map map;
            Object typeObj;
            if (!(recipe instanceof Map) || !((typeObj = (map = (Map)recipe).get("type")) instanceof String)) continue;
            String type = (String)typeObj;
            LinkedHashMap<Object, Object> data = new LinkedHashMap<Object, Object>(map);
            data.remove("type");
            RecipeHandler handler = HANDLERS.get(type);
            if (handler == null) continue;
            handler.handle(data);
        }
    }

    @ApiStatus.Internal
    public static void reload() {
        Registries.SHAPED_RECIPES.getAll().values().forEach(v -> Bukkit.addRecipe((Recipe)v, (boolean)true));
        Registries.SHAPELESS_RECIPES.getAll().values().forEach(v -> Bukkit.addRecipe((Recipe)v, (boolean)true));
        Registries.TRANSMUTE_RECIPES.getAll().values().forEach(v -> Bukkit.addRecipe((Recipe)v, (boolean)true));
        Registries.FURNACE_RECIPES.getAll().values().forEach(v -> Bukkit.addRecipe((Recipe)v, (boolean)true));
        Registries.BLASTING_RECIPES.getAll().values().forEach(v -> Bukkit.addRecipe((Recipe)v, (boolean)true));
        Registries.SMOKING_RECIPES.getAll().values().forEach(v -> Bukkit.addRecipe((Recipe)v, (boolean)true));
        Registries.CAMPFIRE_RECIPES.getAll().values().forEach(v -> Bukkit.addRecipe((Recipe)v, (boolean)true));
        Registries.STONECUTTING_RECIPES.getAll().values().forEach(v -> Bukkit.addRecipe((Recipe)v, (boolean)true));
        Registries.SMITHING_TRANSFORM_RECIPES.getAll().values().forEach(v -> Bukkit.addRecipe((Recipe)v, (boolean)true));
        Registries.POTION_MIXES.getAll().values().forEach(p -> Bukkit.getPotionBrewer().addPotionMix(p));
    }

    static {
        RecipeLoader.registerHandler("minecraft:shaped", data -> {
            ShapedRecipe r = Codecs.SHAPED_RECIPE.decode(YamlOps.INSTANCE, data);
            if (r != null) {
                Registries.SHAPED_RECIPES.register(r.getKey().toString(), r);
            }
        });
        RecipeLoader.registerHandler("minecraft:shapeless", data -> {
            ShapelessRecipe r = Codecs.SHAPELESS_RECIPE.decode(YamlOps.INSTANCE, data);
            if (r != null) {
                Registries.SHAPELESS_RECIPES.register(r.getKey().toString(), r);
            }
        });
        RecipeLoader.registerHandler("minecraft:transmute", data -> {
            TransmuteRecipe r = Codecs.TRANSMUTE_RECIPE.decode(YamlOps.INSTANCE, data);
            if (r != null) {
                Registries.TRANSMUTE_RECIPES.register(r.getKey().toString(), r);
            }
        });
        RecipeLoader.registerHandler("minecraft:furnace", data -> {
            FurnaceRecipe r = Codecs.FURNACE_RECIPE.decode(YamlOps.INSTANCE, data);
            if (r != null) {
                Registries.FURNACE_RECIPES.register(r.getKey().toString(), r);
            }
        });
        RecipeLoader.registerHandler("minecraft:blasting", data -> {
            BlastingRecipe r = Codecs.BLASTING_RECIPE.decode(YamlOps.INSTANCE, data);
            if (r != null) {
                Registries.BLASTING_RECIPES.register(r.getKey().toString(), r);
            }
        });
        RecipeLoader.registerHandler("minecraft:smoking", data -> {
            SmokingRecipe r = Codecs.SMOKING_RECIPE.decode(YamlOps.INSTANCE, data);
            if (r != null) {
                Registries.SMOKING_RECIPES.register(r.getKey().toString(), r);
            }
        });
        RecipeLoader.registerHandler("minecraft:campfire", data -> {
            CampfireRecipe r = Codecs.CAMPFIRE_RECIPE.decode(YamlOps.INSTANCE, data);
            if (r != null) {
                Registries.CAMPFIRE_RECIPES.register(r.getKey().toString(), r);
            }
        });
        RecipeLoader.registerHandler("minecraft:smithing_transform", data -> {
            SmithingTransformRecipe r = Codecs.SMITHING_TRANSFORM_RECIPE.decode(YamlOps.INSTANCE, data);
            if (r != null) {
                Registries.SMITHING_TRANSFORM_RECIPES.register(r.getKey().toString(), r);
            }
        });
        RecipeLoader.registerHandler("minecraft:stonecutting", data -> {
            StonecuttingRecipe r = Codecs.STONECUTTING_RECIPE.decode(YamlOps.INSTANCE, data);
            if (r != null) {
                Registries.STONECUTTING_RECIPES.register(r.getKey().toString(), r);
            }
        });
        RecipeLoader.registerHandler("minecraft:potion_mix", data -> {
            PotionMix r = Codecs.POTION_MIX.decode(YamlOps.INSTANCE, data);
            if (r != null) {
                Registries.POTION_MIXES.register(r.getKey().toString(), r);
            }
        });
    }

    @FunctionalInterface
    public static interface RecipeHandler {
        public void handle(Map<Object, Object> var1) throws Codec.CodecException;
    }
}

