/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.config.legacy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;

public class ConfigParser {
    public static Object parseValue(JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive prim = element.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            if (prim.isNumber()) {
                double d = prim.getAsDouble();
                return d % 1.0 == 0.0 ? (double)((int)d) : d;
            }
            if (prim.isString()) {
                String raw = prim.getAsString();
                return ConfigParser.parseTypedString(raw);
            }
        } else {
            if (element.isJsonArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (JsonElement el : element.getAsJsonArray()) {
                    list.add(ConfigParser.parseValue(el));
                }
                return list;
            }
            if (element.isJsonNull()) {
                return null;
            }
        }
        return element.toString();
    }

    public static JsonElement serializeValue(Object value) {
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return new JsonPrimitive(i + "i");
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return new JsonPrimitive(l + "L");
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return new JsonPrimitive(f + "f");
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            return new JsonPrimitive((Number)d);
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return new JsonPrimitive(b);
        }
        if (value instanceof String) {
            String s = (String)value;
            return new JsonPrimitive(s);
        }
        if (value instanceof List) {
            List list = (List)value;
            JsonArray array = new JsonArray();
            for (Object obj : list) {
                JsonElement el = ConfigParser.serializeValue(obj);
                if (el == null) continue;
                array.add(el);
            }
            return array;
        }
        return null;
    }

    public static List<Object> parseList(String input, List<?> defaultList) {
        ArrayList<Object> result = new ArrayList<Object>();
        String[] parts = input.split(",");
        Object hint = defaultList.isEmpty() ? null : defaultList.get(0);
        for (String part : parts) {
            String trimmed = part.trim();
            if (trimmed.isEmpty()) continue;
            Object parsed = hint instanceof Integer ? Integer.valueOf(Integer.parseInt(trimmed)) : (hint instanceof Long ? Long.valueOf(Long.parseLong(trimmed)) : (hint instanceof Float ? Float.valueOf(Float.parseFloat(trimmed)) : (hint instanceof Double ? Double.valueOf(Double.parseDouble(trimmed)) : (hint instanceof Boolean ? Boolean.valueOf(Boolean.parseBoolean(trimmed)) : (hint instanceof String ? trimmed : ConfigParser.parseTypedString(trimmed))))));
            result.add(parsed);
        }
        return result;
    }

    public static Object parseTypedString(String raw) {
        if (raw.endsWith("i")) {
            try {
                return Integer.parseInt(raw.substring(0, raw.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (raw.endsWith("L")) {
            try {
                return Long.parseLong(raw.substring(0, raw.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (raw.endsWith("f")) {
            try {
                return Float.valueOf(Float.parseFloat(raw.substring(0, raw.length() - 1)));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (raw.endsWith("d")) {
            try {
                return Double.parseDouble(raw.substring(0, raw.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return raw;
    }
}

