/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.serialization;

import com.destroystokyo.paper.profile.ProfileProperty;
import com.github.darksoulq.abyssallib.common.serialization.Codec;
import com.github.darksoulq.abyssallib.common.serialization.Codecs;
import com.github.darksoulq.abyssallib.common.serialization.RecordCodecBuilder;
import io.papermc.paper.block.BlockPredicate;
import io.papermc.paper.datacomponent.item.BannerPatternLayers;
import io.papermc.paper.datacomponent.item.BlocksAttacks;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.Equippable;
import io.papermc.paper.datacomponent.item.Fireworks;
import io.papermc.paper.datacomponent.item.FoodProperties;
import io.papermc.paper.datacomponent.item.ItemAdventurePredicate;
import io.papermc.paper.datacomponent.item.ItemAttributeModifiers;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.LodestoneTracker;
import io.papermc.paper.datacomponent.item.MapDecorations;
import io.papermc.paper.datacomponent.item.PotDecorations;
import io.papermc.paper.datacomponent.item.Repairable;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.datacomponent.item.SeededContainerLoot;
import io.papermc.paper.datacomponent.item.Tool;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import io.papermc.paper.datacomponent.item.UseCooldown;
import io.papermc.paper.datacomponent.item.Weapon;
import io.papermc.paper.datacomponent.item.WrittenBookContent;
import io.papermc.paper.datacomponent.item.blocksattacks.DamageReduction;
import io.papermc.paper.datacomponent.item.blocksattacks.ItemDamageFunction;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import io.papermc.paper.datacomponent.item.consumable.ItemUseAnimation;
import io.papermc.paper.potion.SuspiciousEffectEntry;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.text.Filtered;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.util.TriState;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Keyed;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class ExtraCodecs {
    public static final Codec<DamageType> DAMAGE_TYPE = Codecs.KEY.xmap(arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE)).getOrThrow(arg_0), arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE)).getKeyOrThrow(arg_0));
    public static final Codec<RegistryKeySet<@NotNull DamageType>> DAMAGE_TYPE_KEYS = DAMAGE_TYPE.list().xmap(l -> RegistrySet.keySetFromValues((RegistryKey)RegistryKey.DAMAGE_TYPE, (Iterable)l), k -> k.resolve(RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE)).stream().toList());
    public static final Codec<BlockType> BLOCK_TYPE = Codecs.KEY.xmap(arg_0 -> ((Registry)Registry.BLOCK).getOrThrow(arg_0), Keyed::getKey);
    public static final Codec<RegistryKeySet<@NotNull BlockType>> BLOCK_TYPE_KEYS = BLOCK_TYPE.list().xmap(l -> RegistrySet.keySetFromValues((RegistryKey)RegistryKey.BLOCK, (Iterable)l), k -> k.resolve(Registry.BLOCK).stream().toList());
    public static final Codec<BlockPredicate> BLOCK_PREDICATE = BLOCK_TYPE_KEYS.xmap(k -> BlockPredicate.predicate().blocks(k).build(), BlockPredicate::blocks);
    public static final Codec<ItemAdventurePredicate> ITEM_ADV_PREDICATE = BLOCK_PREDICATE.list().xmap(ItemAdventurePredicate::itemAdventurePredicate, ItemAdventurePredicate::predicates);
    public static final Codec<ItemType> ITEM_TYPE = Codecs.KEY.xmap(arg_0 -> ((Registry)Registry.ITEM).getOrThrow(arg_0), Keyed::getKey);
    public static final Codec<EntityType> ENTITY_TYPE = Codecs.KEY.xmap(arg_0 -> ((Registry)Registry.ENTITY_TYPE).getOrThrow(arg_0), EntityType::getKey);
    public static final Codec<PatternType> BANNER_PATTERN_TYPE = Codecs.KEY.xmap(arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.BANNER_PATTERN)).get(arg_0), arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.BANNER_PATTERN)).getKey(arg_0));
    public static final Codec<Pattern> BANNER_PATTERN = RecordCodecBuilder.create(Codec.enumCodec(DyeColor.class).fieldOf("color", Pattern::getColor), BANNER_PATTERN_TYPE.fieldOf("pattern", Pattern::getPattern), Pattern::new);
    public static final Codec<BannerPatternLayers> BANNER_PATTERN_LAYERS = BANNER_PATTERN.list().xmap(BannerPatternLayers::bannerPatternLayers, BannerPatternLayers::patterns);
    public static final Codec<Color> COLOR = RecordCodecBuilder.create(Codecs.INT.fieldOf("alpha", Color::getAlpha), Codecs.INT.fieldOf("red", Color::getRed), Codecs.INT.fieldOf("green", Color::getGreen), Codecs.INT.fieldOf("blue", Color::getBlue), Color::fromARGB);
    public static final Codec<UseCooldown> USE_COOLDOWN = RecordCodecBuilder.create(Codecs.FLOAT.fieldOf("cooldown", UseCooldown::seconds), Codecs.KEY.optional().fieldOf("group", c -> Optional.ofNullable(c.cooldownGroup())), (cd, group) -> group.map(key -> (UseCooldown)UseCooldown.useCooldown((float)cd.floatValue()).cooldownGroup(key).build()).orElseGet(() -> (UseCooldown)UseCooldown.useCooldown((float)cd.floatValue()).build()));
    public static final Codec<MapCursor.Type> MAP_CURSOR_TYPE = Codecs.KEY.xmap(arg_0 -> ((Registry)Registry.MAP_DECORATION_TYPE).get(arg_0), Keyed::getKey);
    public static final Codec<MapDecorations.DecorationEntry> MAP_DECO_ENTRY = RecordCodecBuilder.create(MAP_CURSOR_TYPE.fieldOf("type", MapDecorations.DecorationEntry::type), Codecs.DOUBLE.fieldOf("x", MapDecorations.DecorationEntry::x), Codecs.DOUBLE.fieldOf("z", MapDecorations.DecorationEntry::z), Codecs.FLOAT.fieldOf("rotation", MapDecorations.DecorationEntry::rotation), MapDecorations::decorationEntry);
    public static final Codec<CustomModelData> CUSTOM_MODEL_DATA = RecordCodecBuilder.create(Codecs.FLOAT.list().fieldOf("floats", CustomModelData::floats), Codecs.BOOLEAN.list().fieldOf("flags", CustomModelData::flags), Codecs.STRING.list().fieldOf("strings", CustomModelData::strings), COLOR.list().fieldOf("colors", CustomModelData::colors), (floats, flags, strings, colors) -> (CustomModelData)CustomModelData.customModelData().addFloats(floats).addFlags(flags).addStrings(strings).addColors(colors).build());
    public static final Codec<Repairable> REPAIRABLE_COMPONENT = ITEM_TYPE.list().xmap(l -> Repairable.repairable((RegistryKeySet)RegistrySet.keySetFromValues((RegistryKey)RegistryKey.ITEM, (Iterable)l)), r -> r.types().resolve(Registry.ITEM).stream().toList());
    public static final Codec<LodestoneTracker> LODESTONE_TRACKER = RecordCodecBuilder.create(Codecs.LOCATION.fieldOf("location", LodestoneTracker::location), Codecs.BOOLEAN.fieldOf("tracked", LodestoneTracker::tracked), LodestoneTracker::lodestoneTracker);
    public static final Codec<Weapon> WEAPON = RecordCodecBuilder.create(Codecs.INT.fieldOf("item_damage_per_attack", Weapon::itemDamagePerAttack), Codecs.FLOAT.fieldOf("disable_blocking_for_seconds", Weapon::disableBlockingForSeconds), (itemDamagePerAttack, disableBlockingForSeconds) -> (Weapon)Weapon.weapon().itemDamagePerAttack(itemDamagePerAttack.intValue()).disableBlockingForSeconds(disableBlockingForSeconds.floatValue()).build());
    public static final Codec<FireworkEffect> FIREWORK_EFFECT = RecordCodecBuilder.create(Codecs.BOOLEAN.fieldOf("flicker", FireworkEffect::hasFlicker), Codecs.BOOLEAN.fieldOf("trail", FireworkEffect::hasTrail), COLOR.list().fieldOf("colors", FireworkEffect::getColors), COLOR.list().fieldOf("fade_colors", FireworkEffect::getFadeColors), Codec.enumCodec(FireworkEffect.Type.class).fieldOf("type", FireworkEffect::getType), (flicker, trail, colors, fadeColors, type) -> FireworkEffect.builder().flicker(flicker.booleanValue()).trail(trail.booleanValue()).with(type).withColor((Iterable)colors).withFade((Iterable)colors).build());
    public static final Codec<Fireworks> FIREWORKS = RecordCodecBuilder.create(FIREWORK_EFFECT.list().fieldOf("effects", Fireworks::effects), Codecs.INT.fieldOf("flight_duration", Fireworks::flightDuration), Fireworks::fireworks);
    public static final Codec<SeededContainerLoot> SEEDED_CONTAINER_LOOT = RecordCodecBuilder.create(Codecs.KEY.fieldOf("loot_table", SeededContainerLoot::lootTable), Codecs.LONG.fieldOf("seed", SeededContainerLoot::seed), SeededContainerLoot::seededContainerLoot);
    public static final Codec<PotDecorations> POT_DECORATIONS = RecordCodecBuilder.create(ITEM_TYPE.fieldOf("front", PotDecorations::front), ITEM_TYPE.fieldOf("back", PotDecorations::back), ITEM_TYPE.fieldOf("left", PotDecorations::left), ITEM_TYPE.fieldOf("right", PotDecorations::right), PotDecorations::potDecorations);
    public static final Codec<FoodProperties> FOOD_PROPERTIES = RecordCodecBuilder.create(Codecs.INT.fieldOf("nutrition", FoodProperties::nutrition), Codecs.FLOAT.fieldOf("saturation", FoodProperties::saturation), Codecs.BOOLEAN.fieldOf("can_always_eat", FoodProperties::canAlwaysEat), (nutrition, saturation, canAlwaysEat) -> (FoodProperties)FoodProperties.food().nutrition(nutrition.intValue()).saturation(saturation.floatValue()).canAlwaysEat(canAlwaysEat.booleanValue()).build());
    public static final Codec<Equippable> EQUIPPABLE = RecordCodecBuilder.create(Codec.enumCodec(EquipmentSlot.class).fieldOf("slot", Equippable::slot), Codecs.KEY.fieldOf("equip_sound", Equippable::equipSound), Codecs.KEY.nullable().fieldOf("asset_id", Equippable::assetId), Codecs.KEY.nullable().fieldOf("camera_overlay", Equippable::cameraOverlay), ENTITY_TYPE.list().nullable().fieldOf("allowed_entities", e -> {
        if (e.allowedEntities() == null) {
            return null;
        }
        return e.allowedEntities().resolve(Registry.ENTITY_TYPE).stream().toList();
    }), Codecs.BOOLEAN.fieldOf("dispensable", Equippable::dispensable), Codecs.BOOLEAN.fieldOf("swappable", Equippable::swappable), Codecs.BOOLEAN.fieldOf("damage_on_hurt", Equippable::damageOnHurt), Codecs.BOOLEAN.fieldOf("can_be_sheared", Equippable::canBeSheared), Codecs.KEY.nullable().fieldOf("shear_sound", Equippable::shearSound), (slot, equipSound, assetId, cameraOverlay, allowedEntities, dispensable, swappable, damageOnHurt, canBeSheared, shearSound) -> {
        Equippable.Builder builder = Equippable.equippable((EquipmentSlot)slot).equipSound(equipSound).assetId(assetId).cameraOverlay(cameraOverlay);
        if (allowedEntities != null) {
            builder.allowedEntities(RegistrySet.keySetFromValues((RegistryKey)RegistryKey.ENTITY_TYPE, (Iterable)allowedEntities));
        }
        return (Equippable)builder.dispensable(dispensable.booleanValue()).swappable(swappable.booleanValue()).damageOnHurt(damageOnHurt.booleanValue()).canBeSheared(canBeSheared.booleanValue()).shearSound(shearSound).build();
    });
    public static final Codec<Enchantment> ENCHANTMENT = Codecs.KEY.xmap(arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT)).getOrThrow(arg_0), Keyed::getKey);
    public static final Codec<ItemEnchantments> ITEM_ENCHANTMENTS = Codec.map(ENCHANTMENT, Codecs.INT).xmap(ItemEnchantments::itemEnchantments, ItemEnchantments::enchantments);
    public static final Codec<TooltipDisplay> TOOLTIP_DISPLAY = RecordCodecBuilder.create(Codecs.BOOLEAN.fieldOf("hide_tooltips", TooltipDisplay::hideTooltip), Codecs.DATA_COMPONENT_TYPE.list().fieldOf("hidden_components", t -> t.hiddenComponents().stream().toList()), (hide, hiddenComponents) -> (TooltipDisplay)TooltipDisplay.tooltipDisplay().hideTooltip(hide.booleanValue()).hiddenComponents(new HashSet(hiddenComponents)).build());
    public static final Codec<TrimMaterial> TRIM_MATERIAL = Codecs.KEY.xmap(arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_MATERIAL)).getOrThrow(arg_0), arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_MATERIAL)).getKeyOrThrow(arg_0));
    public static final Codec<TrimPattern> TRIM_PATTERN = Codecs.KEY.xmap(arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_PATTERN)).getOrThrow(arg_0), arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_PATTERN)).getKeyOrThrow(arg_0));
    public static final Codec<ArmorTrim> ARMOR_TRIM = RecordCodecBuilder.create(TRIM_MATERIAL.fieldOf("material", ArmorTrim::getMaterial), TRIM_PATTERN.fieldOf("pattern", ArmorTrim::getPattern), ArmorTrim::new);
    public static final Codec<Filtered<String>> FILTERED_STRING = Codecs.STRING.xmap(s -> Filtered.of((Object)s, null), Filtered::raw);
    public static final Codec<Filtered<ComponentLike>> FILTERED_COMPONENT = Codecs.TEXT_COMPONENT.xmap(c -> Filtered.of((Object)c, null), f -> ((ComponentLike)f.raw()).asComponent());
    public static final Codec<WrittenBookContent> WRITTEN_BOOK_CONTENT = RecordCodecBuilder.create(FILTERED_STRING.fieldOf("title", WrittenBookContent::title), Codecs.STRING.fieldOf("author", WrittenBookContent::author), Codecs.INT.fieldOf("generation", WrittenBookContent::generation), FILTERED_COMPONENT.list().fieldOf("pages", w -> {
        ArrayList comps = new ArrayList();
        w.pages().forEach(fc -> comps.add(Filtered.of((Object)((ComponentLike)fc.raw()), null)));
        return comps;
    }), Codecs.BOOLEAN.fieldOf("resolved", WrittenBookContent::resolved), (title, author, gen, pages, resolved) -> {
        WrittenBookContent.Builder builder = WrittenBookContent.writtenBookContent((Filtered)title, (String)author).resolved(resolved.booleanValue());
        pages.forEach(p -> builder.addPage((ComponentLike)p.raw()));
        return (WrittenBookContent)builder.build();
    });
    public static final Codec<ConsumeEffect.TeleportRandomly> CONSUME_TELEPORT_RANDOMLY = Codecs.FLOAT.xmap(ConsumeEffect::teleportRandomlyEffect, ConsumeEffect.TeleportRandomly::diameter);
    public static Codec<ConsumeEffect.PlaySound> CONSUME_PLAY_SOUND = Codecs.KEY.xmap(ConsumeEffect::playSoundConsumeEffect, ConsumeEffect.PlaySound::sound);
    public static Codec<PotionEffectType> POTION_EFFECT_TYPE = Codecs.KEY.xmap(arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.MOB_EFFECT)).getOrThrow(arg_0), arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.MOB_EFFECT)).getKeyOrThrow(arg_0));
    public static Codec<RegistryKeySet<@NotNull PotionEffectType>> POTION_EFFECT_TYPES = POTION_EFFECT_TYPE.list().xmap(k -> RegistrySet.keySetFromValues((RegistryKey)RegistryKey.MOB_EFFECT, (Iterable)k), s -> s.resolve(Registry.POTION_EFFECT_TYPE).stream().toList());
    public static Codec<ConsumeEffect.RemoveStatusEffects> CONSUME_REMOVE_STATUS_EFFECTS = POTION_EFFECT_TYPES.xmap(ConsumeEffect::removeEffects, ConsumeEffect.RemoveStatusEffects::removeEffects);
    public static Codec<PotionEffect> POTION_EFFECT = RecordCodecBuilder.create(Codecs.INT.fieldOf("amplifier", PotionEffect::getAmplifier), Codecs.INT.fieldOf("duration", PotionEffect::getDuration), POTION_EFFECT_TYPE.fieldOf("type", PotionEffect::getType), Codecs.BOOLEAN.fieldOf("ambient", PotionEffect::isAmbient), Codecs.BOOLEAN.fieldOf("particles", PotionEffect::hasParticles), Codecs.BOOLEAN.fieldOf("icon", PotionEffect::hasIcon), (amplifier, duration, type, ambient, particles, icon) -> new PotionEffect(type, duration.intValue(), amplifier.intValue(), ambient.booleanValue(), particles.booleanValue(), icon.booleanValue()));
    public static Codec<ConsumeEffect.ApplyStatusEffects> CONSUME_APPLY_STATUS_EFFECTS = RecordCodecBuilder.create(POTION_EFFECT.list().fieldOf("effects", ConsumeEffect.ApplyStatusEffects::effects), Codecs.FLOAT.fieldOf("probability", ConsumeEffect.ApplyStatusEffects::probability), ConsumeEffect::applyStatusEffects);
    public static Codec<ConsumeEffect.ClearAllStatusEffects> CONSUME_CLEAR_ALL_EFFECTS = Codec.of(o -> ConsumeEffect.clearAllStatusEffects(), null);
    public static Codec<ConsumeEffect> CONSUME_EFFECT = Codec.either(CONSUME_APPLY_STATUS_EFFECTS, Codec.either(CONSUME_PLAY_SOUND, Codec.either(CONSUME_TELEPORT_RANDOMLY, Codec.either(CONSUME_REMOVE_STATUS_EFFECTS, CONSUME_CLEAR_ALL_EFFECTS))));
    public static Codec<SuspiciousEffectEntry> SUSPICIOUS_EFFECT_ENTRY = RecordCodecBuilder.create(POTION_EFFECT_TYPE.fieldOf("effect_type", SuspiciousEffectEntry::effect), Codecs.INT.fieldOf("duration", SuspiciousEffectEntry::duration), SuspiciousEffectEntry::create);
    public static Codec<ProfileProperty> PROFILE_PROPERTY = RecordCodecBuilder.create(Codecs.STRING.fieldOf("name", ProfileProperty::getName), Codecs.STRING.fieldOf("value", ProfileProperty::getValue), Codecs.STRING.nullable().fieldOf("signature", ProfileProperty::getSignature), ProfileProperty::new);
    public static Codec<ResolvableProfile> RESOLVABLE_PROFILE = RecordCodecBuilder.create(Codecs.STRING.nullable().fieldOf("name", ResolvableProfile::name), Codecs.UUID.nullable().fieldOf("uuid", ResolvableProfile::uuid), PROFILE_PROPERTY.list().fieldOf("properties", p -> p.properties().stream().toList()), (name, uuid, properties) -> (ResolvableProfile)ResolvableProfile.resolvableProfile().name(name).uuid(uuid).addProperties((Collection)properties).build());
    public static Codec<Tool.Rule> TOOL_RULE = RecordCodecBuilder.create(BLOCK_TYPE_KEYS.fieldOf("blocks", Tool.Rule::blocks), Codecs.FLOAT.fieldOf("speed", Tool.Rule::speed), Codec.enumCodec(TriState.class).fieldOf("correct_for_drops", Tool.Rule::correctForDrops), Tool::rule);
    public static Codec<Tool> TOOL = RecordCodecBuilder.create(Codecs.FLOAT.fieldOf("default_mining_speed", Tool::defaultMiningSpeed), Codecs.INT.fieldOf("damage_per_block", Tool::damagePerBlock), TOOL_RULE.list().fieldOf("rules", Tool::rules), Codecs.BOOLEAN.fieldOf("can_destroy_blocks_in_creative", Tool::canDestroyBlocksInCreative), (defaultMiningSpeed, damagePerBlock, rules, canDestroyBlocksInCreative) -> (Tool)Tool.tool().defaultMiningSpeed(defaultMiningSpeed.floatValue()).damagePerBlock(damagePerBlock.intValue()).addRules((Collection)rules).canDestroyBlocksInCreative(canDestroyBlocksInCreative.booleanValue()).build());
    public static Codec<Consumable> CONSUMABLE = RecordCodecBuilder.create(Codecs.FLOAT.fieldOf("consume_seconds", Consumable::consumeSeconds), Codec.enumCodec(ItemUseAnimation.class).fieldOf("animation", Consumable::animation), Codecs.KEY.fieldOf("sound", Consumable::sound), Codecs.BOOLEAN.fieldOf("has_consume_particles", Consumable::hasConsumeParticles), CONSUME_EFFECT.list().fieldOf("consume_effects", Consumable::consumeEffects), (consumeSeconds, animation, sound, hasConsumeParticles, consumeEffects) -> (Consumable)Consumable.consumable().consumeSeconds(consumeSeconds.floatValue()).animation(animation).sound(sound).hasConsumeParticles(hasConsumeParticles.booleanValue()).addEffects(consumeEffects).build());
    public static Codec<ItemDamageFunction> ITEM_DAMAGE_FUNCTION = RecordCodecBuilder.create(Codecs.FLOAT.fieldOf("threshold", ItemDamageFunction::threshold), Codecs.FLOAT.fieldOf("base", ItemDamageFunction::base), Codecs.FLOAT.fieldOf("factor", ItemDamageFunction::factor), (threshold, base, factor) -> (ItemDamageFunction)ItemDamageFunction.itemDamageFunction().threshold(threshold.floatValue()).base(base.floatValue()).factor(factor.floatValue()).build());
    public static Codec<DamageReduction> DAMAGE_REDUCTION = RecordCodecBuilder.create(DAMAGE_TYPE_KEYS.fieldOf("type", DamageReduction::type), Codecs.FLOAT.fieldOf("horizontal_blocking_angle", DamageReduction::horizontalBlockingAngle), Codecs.FLOAT.fieldOf("base", DamageReduction::base), Codecs.FLOAT.fieldOf("factor", DamageReduction::factor), (type, horizontalBlockingAngle, base, factor) -> (DamageReduction)DamageReduction.damageReduction().type(type).horizontalBlockingAngle(horizontalBlockingAngle.floatValue()).base(base.floatValue()).factor(factor.floatValue()).build());
    public static Codec<BlocksAttacks> BLOCKS_ATTACKS = RecordCodecBuilder.create(Codecs.FLOAT.fieldOf("block_delay_seconds", BlocksAttacks::blockDelaySeconds), Codecs.FLOAT.fieldOf("disable_cooldown_scale", BlocksAttacks::disableCooldownScale), DAMAGE_REDUCTION.list().fieldOf("damage_reductions", BlocksAttacks::damageReductions), ITEM_DAMAGE_FUNCTION.fieldOf("item_damage", BlocksAttacks::itemDamage), DAMAGE_TYPE.nullable().fieldOf("bypassed_by", b -> {
        TagKey bypassedBy = b.bypassedBy();
        if (bypassedBy == null) {
            return null;
        }
        return (DamageType)RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE).getOrThrow(bypassedBy.key());
    }), Codecs.KEY.nullable().fieldOf("block_sound", BlocksAttacks::blockSound), Codecs.KEY.nullable().fieldOf("disable_sound", BlocksAttacks::disableSound), (blockDelaySeconds, disableCooldownScale, damageReductions, itemDamage, bypassedBy, blockSound, disableSound) -> {
        BlocksAttacks.Builder builder = BlocksAttacks.blocksAttacks().blockDelaySeconds(blockDelaySeconds.floatValue()).disableCooldownScale(disableCooldownScale.floatValue()).damageReductions(damageReductions).itemDamage(itemDamage).blockSound(blockSound).disableSound(disableSound);
        if (bypassedBy != null) {
            builder.bypassedBy(TagKey.create((RegistryKey)RegistryKey.DAMAGE_TYPE, (Key)bypassedBy.key()));
        }
        return (BlocksAttacks)builder.build();
    });
    public static Codec<EquipmentSlotGroup> EQUIPMENT_SLOT_GROUP = Codecs.STRING.xmap(EquipmentSlotGroup::getByName, EquipmentSlotGroup::toString);
    public static Codec<Attribute> ATTRIBUTE = Codecs.KEY.xmap(arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.ATTRIBUTE)).getOrThrow(arg_0), arg_0 -> ((Registry)RegistryAccess.registryAccess().getRegistry(RegistryKey.ATTRIBUTE)).getKeyOrThrow(arg_0));
    public static Codec<AttributeModifier> ATTRIBUTE_MODIFIER = RecordCodecBuilder.create(Codecs.NAMESPACED_KEY.fieldOf("key", AttributeModifier::getKey), Codecs.DOUBLE.fieldOf("amount", AttributeModifier::getAmount), Codec.enumCodec(AttributeModifier.Operation.class).fieldOf("operation", AttributeModifier::getOperation), EQUIPMENT_SLOT_GROUP.fieldOf("slot", AttributeModifier::getSlotGroup), AttributeModifier::new);
    public static final Codec<ItemAttributeModifiers> ITEM_ATTRIBUTE_MODIFIERS = Codec.map(ATTRIBUTE, Codec.map(ATTRIBUTE_MODIFIER, EQUIPMENT_SLOT_GROUP)).xmap(map -> {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.itemAttributes();
        map.forEach((attribute, inner) -> inner.forEach((modifier, group) -> builder.addModifier(attribute, modifier, group)));
        return (ItemAttributeModifiers)builder.build();
    }, modifiers -> {
        LinkedHashMap<Attribute, Map> map = new LinkedHashMap<Attribute, Map>();
        for (ItemAttributeModifiers.Entry e : modifiers.modifiers()) {
            map.computeIfAbsent(e.attribute(), k -> new LinkedHashMap()).put(e.modifier(), e.getGroup());
        }
        return map;
    });
}

