/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.extension;

import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.extension.GiveResult;
import com.github.darksoulq.abyssallib.server.chat.ChatInputHandler;
import com.github.darksoulq.abyssallib.world.data.statistic.PlayerStatistics;
import com.github.darksoulq.abyssallib.world.data.statistic.Statistic;
import com.github.darksoulq.abyssallib.world.gui.Gui;
import com.github.darksoulq.abyssallib.world.gui.GuiManager;
import com.github.darksoulq.abyssallib.world.item.Item;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r\u001a \u0010\u0006\u001a\u00020\u0007*\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u001a\u0018\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u001a \u0010\u0011\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u001a \u0010\u0011\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u0018\u001a(\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0012\u0010\u001e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u001b\u00a8\u0006 "}, d2={"openGui", "", "Lorg/bukkit/entity/Player;", "gui", "Lcom/github/darksoulq/abyssallib/world/gui/Gui;", "closeGui", "give", "Lcom/github/darksoulq/abyssallib/extension/GiveResult;", "item", "Lcom/github/darksoulq/abyssallib/world/item/Item;", "shouldDrop", "", "items", "", "remainingSpaceFor", "", "Lorg/bukkit/inventory/ItemStack;", "chatInput", "inputHandler", "Ljava/util/function/Consumer;", "", "prompt", "Lnet/kyori/adventure/text/Component;", "timeoutTicks", "", "cancelChatInput", "getStat", "Lcom/github/darksoulq/abyssallib/world/data/statistic/Statistic;", "id", "Lcom/github/darksoulq/abyssallib/common/util/Identifier;", "setStat", "stat", "AbyssalLib"})
@SourceDebugExtension(value={"SMAP\nPlayerExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerExtensions.kt\ncom/github/darksoulq/abyssallib/extension/PlayerExtensionsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,143:1\n12734#2,3:144\n*S KotlinDebug\n*F\n+ 1 PlayerExtensions.kt\ncom/github/darksoulq/abyssallib/extension/PlayerExtensionsKt\n*L\n111#1:144,3\n*E\n"})
public final class PlayerExtensionsKt {
    public static final void openGui(@NotNull Player $this$openGui, @NotNull Gui gui) {
        Intrinsics.checkNotNullParameter((Object)$this$openGui, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gui, (String)"gui");
        GuiManager.close((HumanEntity)$this$openGui);
        GuiManager.open((HumanEntity)$this$openGui, gui);
    }

    public static final void closeGui(@NotNull Player $this$closeGui) {
        Intrinsics.checkNotNullParameter((Object)$this$closeGui, (String)"<this>");
        GuiManager.close((HumanEntity)$this$closeGui);
    }

    @NotNull
    public static final GiveResult give(@NotNull Player $this$give, @NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)$this$give, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return PlayerExtensionsKt.give($this$give, item, true);
    }

    @NotNull
    public static final GiveResult give(@NotNull Player $this$give, @NotNull Item item, boolean shouldDrop) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$give, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ItemStack itemStack = item.getStack().clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack stack = itemStack;
        int remaining = PlayerExtensionsKt.remainingSpaceFor($this$give, CollectionsKt.listOf((Object)stack));
        ItemStack itemStack2 = stack.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
        ItemStack toGive = itemStack2;
        toGive.setAmount(RangesKt.coerceAtMost((int)remaining, (int)stack.getAmount()));
        ItemStack[] itemStackArray = new ItemStack[]{toGive};
        $this$give.give(itemStackArray);
        int leftoverAmount = stack.getAmount() - toGive.getAmount();
        if (leftoverAmount <= 0) {
            return new GiveResult(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        ItemStack itemStack3 = stack.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"clone(...)");
        ItemStack leftoverStack = itemStack3;
        leftoverStack.setAmount(leftoverAmount);
        Item leftoverItem = Item.resolve(leftoverStack);
        if (shouldDrop) {
            $this$give.getWorld().dropItemNaturally($this$give.getLocation(), leftoverStack);
            list = CollectionsKt.listOf((Object)leftoverItem);
        } else {
            list = CollectionsKt.emptyList();
        }
        List drops = list;
        List leftovers = shouldDrop ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)leftoverItem);
        return new GiveResult(leftovers, drops);
    }

    @NotNull
    public static final GiveResult give(@NotNull Player $this$give, @NotNull List<? extends Item> items) {
        Intrinsics.checkNotNullParameter((Object)$this$give, (String)"<this>");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        return PlayerExtensionsKt.give($this$give, items, true);
    }

    @NotNull
    public static final GiveResult give(@NotNull Player $this$give, @NotNull List<? extends Item> items, boolean shouldDrop) {
        Intrinsics.checkNotNullParameter((Object)$this$give, (String)"<this>");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        List totalLeftovers = new ArrayList();
        List totalDrops = new ArrayList();
        block0: for (Item item : items) {
            ItemStack stack;
            Intrinsics.checkNotNullExpressionValue((Object)item.getStack().clone(), (String)"clone(...)");
            while (stack.getAmount() > 0) {
                ItemStack toGive;
                int remaining = PlayerExtensionsKt.remainingSpaceFor($this$give, CollectionsKt.listOf((Object)stack));
                if (remaining <= 0) {
                    boolean bl;
                    if (shouldDrop) {
                        $this$give.getWorld().dropItemNaturally($this$give.getLocation(), stack.clone());
                        Item item2 = Item.resolve(stack.clone());
                        Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"resolve(...)");
                        bl = totalDrops.add(item2);
                        continue block0;
                    }
                    Item item3 = Item.resolve(stack.clone());
                    Intrinsics.checkNotNullExpressionValue((Object)item3, (String)"resolve(...)");
                    bl = totalLeftovers.add(item3);
                    continue block0;
                }
                Intrinsics.checkNotNullExpressionValue((Object)stack.clone(), (String)"clone(...)");
                toGive.setAmount(RangesKt.coerceAtMost((int)remaining, (int)stack.getAmount()));
                ItemStack[] itemStackArray = new ItemStack[]{toGive};
                $this$give.give(itemStackArray);
                stack.setAmount(stack.getAmount() - toGive.getAmount());
            }
        }
        return new GiveResult(totalLeftovers, totalDrops);
    }

    public static final int remainingSpaceFor(@NotNull Player $this$remainingSpaceFor, @NotNull List<? extends ItemStack> items) {
        Intrinsics.checkNotNullParameter((Object)$this$remainingSpaceFor, (String)"<this>");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        int totalSpace = 0;
        PlayerInventory playerInventory = $this$remainingSpaceFor.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)playerInventory, (String)"getInventory(...)");
        PlayerInventory inv = playerInventory;
        ItemStack[] itemStackArray = inv.getStorageContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getStorageContents(...)");
        ItemStack[] contents = itemStackArray;
        for (ItemStack itemStack : items) {
            int max;
            Integer n = (Integer)itemStack.getData(DataComponentTypes.MAX_STACK_SIZE);
            int amountLeft = max = n != null ? n : 1;
            int n2 = contents.length;
            for (int i = 0; i < n2; ++i) {
                int remaining;
                ItemStack slot = contents[i];
                if (slot == null) {
                    amountLeft = 0;
                    break;
                }
                if (slot.isSimilar(itemStack) && (remaining = max - slot.getAmount()) > 0 && (amountLeft -= remaining) <= 0) break;
            }
            if (amountLeft > 0) {
                ItemStack[] $this$count$iv = contents;
                boolean $i$f$count = false;
                int count$iv = 0;
                int n3 = $this$count$iv.length;
                for (int i = 0; i < n3; ++i) {
                    ItemStack element$iv;
                    ItemStack it = element$iv = $this$count$iv[i];
                    boolean bl = false;
                    if (!(it == null)) continue;
                    ++count$iv;
                }
                int emptySlots = count$iv;
                int spaceFromEmpty = emptySlots * max;
                totalSpace += max - amountLeft + spaceFromEmpty;
                continue;
            }
            totalSpace += max;
        }
        return totalSpace;
    }

    public static final void chatInput(@NotNull Player $this$chatInput, @NotNull Consumer<String> inputHandler) {
        Intrinsics.checkNotNullParameter((Object)$this$chatInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(inputHandler, (String)"inputHandler");
        ChatInputHandler.await($this$chatInput, inputHandler);
    }

    public static final void chatInput(@NotNull Player $this$chatInput, @NotNull Consumer<String> inputHandler, @NotNull Component prompt) {
        Intrinsics.checkNotNullParameter((Object)$this$chatInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(inputHandler, (String)"inputHandler");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        ChatInputHandler.await($this$chatInput, inputHandler, prompt);
    }

    public static final void chatInput(@NotNull Player $this$chatInput, @NotNull Consumer<String> inputHandler, long timeoutTicks) {
        Intrinsics.checkNotNullParameter((Object)$this$chatInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(inputHandler, (String)"inputHandler");
        ChatInputHandler.await($this$chatInput, inputHandler, timeoutTicks);
    }

    public static final void chatInput(@NotNull Player $this$chatInput, @NotNull Consumer<String> inputHandler, @NotNull Component prompt, long timeoutTicks) {
        Intrinsics.checkNotNullParameter((Object)$this$chatInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(inputHandler, (String)"inputHandler");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        ChatInputHandler.await($this$chatInput, inputHandler, prompt, timeoutTicks);
    }

    public static final void cancelChatInput(@NotNull Player $this$cancelChatInput) {
        Intrinsics.checkNotNullParameter((Object)$this$cancelChatInput, (String)"<this>");
        ChatInputHandler.cancel($this$cancelChatInput);
    }

    @Nullable
    public static final Statistic getStat(@NotNull Player $this$getStat, @NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)$this$getStat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return PlayerStatistics.of($this$getStat).get(id);
    }

    public static final void setStat(@NotNull Player $this$setStat, @NotNull Statistic stat) {
        Intrinsics.checkNotNullParameter((Object)$this$setStat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        PlayerStatistics.of($this$setStat).set(stat);
    }
}

